/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.application.common.services.util.FileUtil;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.operations.CopyFileOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.ast.EditUtil;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.ast.WriterUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifact;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class TaskFlowManagedBeanOperation
extends AbstractBasicOperation {
    private static final String TASK_FLOW_ID_IMPORT = "oracle.adf.controller.TaskFlowId";
    private static final String TASK_FLOW_FIELD_IDENTIFIER = "taskFlowId";
    private static final String TASK_FLOW_METHOD_IDENTIFIER = "getDynamicTaskFlowId";
    private static final String TASK_FLOW_FIELD_DECL = "private String taskFlowId = ";
    private static final String TASK_FLOW_METHOD_DECL = "public TaskFlowId getDynamicTaskFlowId() {  \treturn TaskFlowId.parse(taskFlowId);}";
    private static final String ADFC_CONFIG_FILE = "adfc-config.xml";
    private static final String ADF_BEAN_CATEGORY_ID = "adf-managed-bean";
    private static final String XML_EXT = "xml";
    private static final String IFILE_PROPERTY = "ManagedBeanUpdateService.IFile.FILE";
    private static final String CLASS_PROPERTY = "ManagedBeanUpdateService.String.CLASS";
    private static final String NAME_PROPERTY = "ManagedBeanUpdateService.String.NAME";
    private static final String SCOPE_PROPERTY = "ManagedBeanUpdateService.String.SCOPE";
    private final IJavaElement beanClass;
    private final String beanClassName;
    private final String beanName;
    private final String taskFlowId;

    public TaskFlowManagedBeanOperation(IJavaElement managedBean, String beanName, String beanClassName, String taskFlowId) {
        super(TaskFlowManagedBeanOperation.class.getClass().getName());
        this.beanClass = managedBean;
        this.beanClassName = beanClassName;
        this.beanName = beanName;
        this.taskFlowId = taskFlowId;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            this.updateManagedBeanFile();
            this.updateAdfcConfigFile();
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)ADFPlugin.getDefault(), (CoreException)e);
            return Status.CANCEL_STATUS;
        }
    }

    public IJavaElement getBeanClass() {
        return this.beanClass;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getTaskFlowId() {
        return this.taskFlowId;
    }

    protected IStatus updateManagedBeanFile() {
        ICompilationUnit icu = this.getCompilationUnit(this.beanClass);
        if (icu != null) {
            WriterContext context = null;
            try {
                IResource resource = this.beanClass.getResource();
                if (!(resource instanceof IFile)) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (!this.validateEdit((IFile)resource).isOK()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                context = EditUtil.startEdit((ICompilationUnit)icu);
                TypeDeclaration typeDeclaration = ReaderUtil.getPrimaryType((CompilationUnit)context.getCompilationUnit());
                if (typeDeclaration == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                String name = ClassUtil.getClassName((String)this.beanClassName);
                if (!typeDeclaration.getName().getIdentifier().equals(name)) {
                    typeDeclaration = ReaderUtil.findInnerType((TypeDeclaration)typeDeclaration, (String)name);
                }
                this.updateImport(context);
                this.updateFieldDeclaration(context, typeDeclaration);
                this.updateMethodDeclaration(context, typeDeclaration);
                EditUtil.endEdit((WriterContext)context);
                context = null;
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (BadLocationException e) {
                LoggingService.logException((Plugin)ADFPlugin.getDefault(), (Throwable)e);
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)ADFPlugin.getDefault(), (CoreException)e);
            }
            finally {
                if (context != null && context.shouldCommit()) {
                    try {
                        context.getICompilationUnit().discardWorkingCopy();
                    }
                    catch (JavaModelException e) {
                        LoggingService.logException((Plugin)ADFPlugin.getDefault(), (CoreException)((Object)e));
                    }
                }
            }
        }
        return Status.CANCEL_STATUS;
    }

    protected void updateImport(WriterContext context) {
        WriterUtil.ensureImport((String)TASK_FLOW_ID_IMPORT, (WriterContext)context);
    }

    protected void updateFieldDeclaration(WriterContext context, TypeDeclaration typeDeclaration) throws BadLocationException, CoreException {
        if (!ReaderUtil.isFieldDeclared((String)TASK_FLOW_FIELD_IDENTIFIER, (ITypeBinding)typeDeclaration.resolveBinding())) {
            WriterUtil.insertField((TypeDeclaration)typeDeclaration, (String)this.getTaskFlowFieldDeclaration(), (WriterContext)context);
        }
    }

    protected void updateMethodDeclaration(WriterContext context, TypeDeclaration typeDeclaration) throws BadLocationException, CoreException {
        List empty = Collections.emptyList();
        IType primaryType = TaskFlowManagedBeanOperation.getTargetIType(this.getBeanClassName(), context.getICompilationUnit().getJavaProject());
        if (primaryType != null && ReaderUtil.findMethod((IType)primaryType, (String)TASK_FLOW_METHOD_IDENTIFIER, empty) == null) {
            WriterUtil.insertMethod((TypeDeclaration)typeDeclaration, (String)TASK_FLOW_METHOD_DECL, (WriterContext)context);
        }
    }

    private ICompilationUnit getCompilationUnit(IJavaElement element) {
        IJavaElement primaryElement = element.getPrimaryElement();
        if (primaryElement instanceof ICompilationUnit) {
            return (ICompilationUnit)primaryElement;
        }
        ICompilationUnit icu = (ICompilationUnit)primaryElement.getAncestor(5);
        return icu;
    }

    private void updateAdfcConfigFile() throws CoreException, ExecutionException {
        IProject project = this.beanClass.getResource().getProject();
        if (!this.isManagedBeanPresent(project)) {
            IFile file = this.getAdfcConfigFile(project);
            if (file == null || !file.exists()) {
                this.createAdfcConfig(project);
                file = this.getAdfcConfigFile(project);
            }
            IDataModel dataModel = DataModelFactory.createDataModel((String)"oracle.eclipse.tools.adf.controller.services.ManagedBeanServiceDataModelProvider");
            dataModel.setBooleanProperty("IDataModelProperties.ALLOW_EXTENSIONS", true);
            dataModel.setProperty(IFILE_PROPERTY, (Object)file);
            dataModel.setProperty(CLASS_PROPERTY, (Object)this.beanClassName);
            dataModel.setProperty(NAME_PROPERTY, (Object)this.beanName);
            dataModel.setProperty(SCOPE_PROPERTY, (Object)"view");
            IDataModelOperation operation = dataModel.getDefaultOperation();
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
    }

    private IStatus createAdfcConfig(IProject project) throws CoreException, ExecutionException {
        String WEB_CONTENT_FOLDER = OperationUtil.getWebContentFolderName((IProject)project);
        CopyFileOperation operation = new CopyFileOperation((Plugin)ADFPlugin.getDefault(), "resources/facet/adfc-config.xml", (IContainer)project, String.valueOf(WEB_CONTENT_FOLDER) + "/WEB-INF", false);
        IStatus status = operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        return status;
    }

    private String getTaskFlowFieldDeclaration() {
        StringBuilder decl = new StringBuilder(TASK_FLOW_FIELD_DECL);
        decl.append("\"");
        decl.append(this.taskFlowId);
        decl.append("\";");
        return decl.toString();
    }

    public static IType getTargetIType(String fullClassName, IJavaProject project) throws JavaModelException {
        String fullyQualified;
        IType targetType = project.findType(fullClassName);
        if (targetType != null && fullClassName.equals(fullyQualified = ClassUtil.$toDot((String)targetType.getFullyQualifiedName()))) {
            return targetType;
        }
        return null;
    }

    private final boolean isManagedBeanPresent(IProject project) {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        if (model == null) {
            return false;
        }
        Set artifacts = model.queryArtifactsByTypes(Collections.singleton(ADF_BEAN_CATEGORY_ID), project);
        for (IArtifact managedBean : artifacts) {
            if (!(managedBean instanceof ManagedBeanArtifact) || !((ManagedBeanArtifact)managedBean).getName().equals(this.beanName)) continue;
            return true;
        }
        return false;
    }

    private IFile getAdfcConfigFile(IProject project) throws CoreException {
        IContainer webContentFolder = OperationUtil.getWebContentFolderIResource((IProject)project);
        List files = FileUtil.getFiles((IContainer)webContentFolder, (String)XML_EXT, (boolean)true);
        for (IFile file : files) {
            if (!file.exists() || !this.isAdfcConfigFile(file)) continue;
            return file;
        }
        project.getFile(ADFC_CONFIG_FILE);
        return null;
    }

    private boolean isAdfcConfigFile(IFile file) {
        return ADFC_CONFIG_FILE.equals(file.getName());
    }

    private IStatus validateEdit(IFile file) {
        if (file != null && file.isAccessible()) {
            IStatus status = ValidateEditUtil.validateEdit((IFile[])new IFile[]{file});
            if (!status.isOK()) {
                LoggingService.logError((Plugin)ADFPlugin.getDefault(), (String)status.getMessage());
            }
            return status;
        }
        return Status.CANCEL_STATUS;
    }

    public static class TaskFlowLinkManagedBeanOperation
    extends TaskFlowManagedBeanOperation {
        private final String taskFlowName;
        private static final String TASKFLOWNAME_METHOD = "TASKFLOWNAME_METHOD";
        private static final String TASKFLOWID_VALUE = "TASKFLOWID_VALUE";
        private static final String TASK_FLOW_LINK_METHOD_DECL = "public String TASKFLOWNAME_METHOD() { taskFlowId = \"TASKFLOWID_VALUE\"; return null; }";

        public TaskFlowLinkManagedBeanOperation(IJavaElement managedBean, String beanName, String beanClassName, String taskFlowId, String taskFlowName) {
            super(managedBean, beanName, beanClassName, taskFlowId);
            this.taskFlowName = taskFlowName;
        }

        @Override
        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.updateManagedBeanFile();
        }

        @Override
        protected void updateImport(WriterContext context) {
        }

        @Override
        protected void updateMethodDeclaration(WriterContext context, TypeDeclaration typeDeclaration) throws BadLocationException, CoreException {
            List empty = Collections.emptyList();
            IType primaryType = TaskFlowLinkManagedBeanOperation.getTargetIType(this.getBeanClassName(), context.getICompilationUnit().getJavaProject());
            if (primaryType != null && ReaderUtil.findMethod((IType)primaryType, (String)this.taskFlowName, empty) == null) {
                WriterUtil.insertMethod((TypeDeclaration)typeDeclaration, (String)this.buildDynamicLinkTaskFlowMethodDeclaration(), (WriterContext)context);
            }
        }

        private String buildDynamicLinkTaskFlowMethodDeclaration() {
            String methodDeclaration = TASK_FLOW_LINK_METHOD_DECL.replaceAll(TASKFLOWNAME_METHOD, this.taskFlowName);
            return methodDeclaration.replaceAll(TASKFLOWID_VALUE, this.getTaskFlowId());
        }
    }
}

