/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.utils;

import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import java.util.Collections;

public class TypeElement {
    private final TypeDeclaration typeDeclaration;

    public TypeElement(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
        this.initialize();
    }

    protected void initialize() {
    }

    public String getSimpleName() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getSimpleName();
        }
        return "";
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    private Collection<? extends MethodDeclaration> getMethodDeclarations() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getMethods();
        }
        return Collections.emptyList();
    }

    public boolean hasExplicitCommit() {
        boolean commit = false;
        boolean rollback = false;
        boolean transactionDirty = false;
        for (MethodDeclaration methodDeclaration : this.getMethodDeclarations()) {
            if ("commitTransaction".equals(methodDeclaration.getSimpleName())) {
                commit = true;
            }
            if ("rollbackTransaction".equals(methodDeclaration.getSimpleName())) {
                rollback = true;
            }
            if (!"isTransactionDirty".equals(methodDeclaration.getSimpleName())) continue;
            transactionDirty = true;
        }
        return commit && rollback && transactionDirty;
    }
}

