/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.utils;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.appgen.appspec.ServiceDefinitionFactory;
import oracle.eclipse.tools.adf.view.appgen.datamodel.ConcurrencyType;
import oracle.eclipse.tools.adf.view.appgen.datamodel.TransactionType;
import oracle.eclipse.tools.adf.view.appgen.utils.EntityUtil;
import oracle.eclipse.tools.adf.view.appgen.utils.SessionBeanAnnotations;
import oracle.eclipse.tools.adf.view.appgen.utils.SessionBeanElement;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.env.EnvironmentFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class SessionBeanUtil {
    private static final Pattern DT_ID_PATTERN = Pattern.compile(".*((?i)generated).*DT_ID=(.*)\\s*$");

    public static boolean validateBeanName(IProject project, String name) {
        if (project == null) {
            return false;
        }
        for (SessionBean sessionBean : SessionBeanUtil.getSessionBeans(project)) {
            if (!sessionBean.getEjbName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public static List<SessionBean> getSessionBeans(IProject project) {
        EJBJar ejbJar;
        EnterpriseBeans enterpriseBeans;
        IModelProvider provider;
        Object modelObject;
        if (project != null && JavaEEProjectUtilities.isEJBProject((IProject)project) && (modelObject = (provider = ModelProviderManager.getModelProvider((IProject)project)).getModelObject()) instanceof EJBJar && (enterpriseBeans = (ejbJar = (EJBJar)modelObject).getEnterpriseBeans()) != null) {
            return enterpriseBeans.getSessionBeans();
        }
        return Collections.emptyList();
    }

    public static SessionBean getSessionBean(IProject project, String classname) {
        if (project == null || classname == null) {
            return null;
        }
        for (SessionBean sb : SessionBeanUtil.getSessionBeans(project)) {
            if (!classname.equals(sb.getEjbClass())) continue;
            return sb;
        }
        return null;
    }

    public static List<GeneratedSessionBean> getGeneratedSessionBeans(IProject project) {
        ArrayList<GeneratedSessionBean> generatedBeans = new ArrayList<GeneratedSessionBean>();
        for (SessionBean sessionBean : SessionBeanUtil.getSessionBeans(project)) {
            IFile beanFile = JavaUtil.getExistingJavaFile((IProject)project, (String)sessionBean.getEjbClass());
            String sdId = SessionBeanUtil.findServiceDefinitionId(beanFile);
            if (sdId == null) continue;
            generatedBeans.add(new GeneratedSessionBean(sessionBean));
        }
        return generatedBeans;
    }

    public static GeneratedSessionBean getGeneratedSessionBean(IFile file) {
        IJavaElement javaElement = JavaCore.create((IFile)file);
        if (javaElement == null) {
            return null;
        }
        IProject project = file.getProject();
        IPath filePath = file.getFullPath();
        for (SessionBean sb : SessionBeanUtil.getSessionBeans(project)) {
            IFile beanFile = JavaUtil.getExistingJavaFile((IProject)project, (String)sb.getEjbClass());
            if (beanFile == null || !beanFile.getFullPath().equals((Object)filePath)) continue;
            String sdId = SessionBeanUtil.findServiceDefinitionId(beanFile);
            if (sdId != null) {
                return new GeneratedSessionBean(sb);
            }
            return null;
        }
        return null;
    }

    public static IServiceDefinition getServiceDefinition(IProject project, GeneratedSessionBean genSessionBean) {
        if (genSessionBean == null || genSessionBean.getSessionBean() == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Invalid session bean");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return null;
        }
        return SessionBeanUtil.reconstructServiceDefinition(project, genSessionBean.getSessionBean());
    }

    public static void reconstructDataModel(IProject project, GeneratedSessionBean genSessionBean, IDataModel dataModel) {
        if (genSessionBean == null || genSessionBean.getSessionBean() == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Invalid session bean");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return;
        }
        String classname = genSessionBean.getSessionBean().getEjbClass();
        IJavaProject javaProject = JavaUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                AnnotationProcessorEnvironment ape;
                TypeDeclaration td;
                ICompilationUnit cu;
                IType type = javaProject.findType(classname);
                if (type != null && (cu = type.getCompilationUnit()) != null && (td = (ape = EnvironmentFactory.getEnvironment((ICompilationUnit)cu, (IJavaProject)javaProject)).getTypeDeclaration(classname)) != null) {
                    SessionBeanElement te = new SessionBeanElement(td);
                    SessionBeanUtil.determineSessionType(dataModel, te);
                    SessionBeanUtil.determineTransactionType(dataModel, te);
                    SessionBeanUtil.determineConcurrency(dataModel, te);
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (CoreException)((Object)e));
            }
        }
    }

    private static IServiceDefinition reconstructServiceDefinition(IProject project, SessionBean sessionBean) {
        if (project == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Invalid session bean");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            return null;
        }
        String classname = sessionBean.getEjbClass();
        IFile beanFile = JavaUtil.getExistingJavaFile((IProject)project, (String)classname);
        if (beanFile != null) {
            IServiceDefinition serviceDefn = ServiceDefinitionFactory.createServiceDefinition();
            serviceDefn.setJpaProjectName(beanFile.getProject().getName());
            for (String entityName : EntityUtil.getClassEntityNames(project, classname)) {
                serviceDefn.addEntityName(entityName);
            }
            return serviceDefn;
        }
        return null;
    }

    private static void determineSessionType(IDataModel dataModel, SessionBeanElement typeElement) {
        if (typeElement.getStatelessAnnotation().hasAnnotation()) {
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATELESS", true);
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATEFUL", false);
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.SINGLETON", false);
        } else if (typeElement.getStatefulAnnotation().hasAnnotation()) {
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATELESS", false);
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATEFUL", true);
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.SINGLETON", false);
        } else if (typeElement.getSingletonAnnotation().hasAnnotation()) {
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATELESS", false);
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.STATEFUL", false);
            dataModel.setBooleanProperty("IServiceDefinitionDataModelProperties.SESSION_TYPE.SINGLETON", true);
        }
    }

    private static void determineConcurrency(IDataModel dataModel, SessionBeanElement typeElement) {
        SessionBeanAnnotations.ConcurrencyAnnotation ca = typeElement.getConcurrencyAnnotation();
        if (ca.hasAnnotation()) {
            if (ca.getValue() != null && ca.getValue().equals(ConcurrencyType.BEAN.toString())) {
                dataModel.setStringProperty("IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE", ConcurrencyType.BEAN.toString());
            }
            if (ca.getValue() != null && ca.getValue().equals(ConcurrencyType.CONTAINER.toString())) {
                dataModel.setStringProperty("IServiceDefinitionDataModelProperties.CONCURRENCY_TYPE", ConcurrencyType.CONTAINER.toString());
            }
        }
    }

    private static void determineTransactionType(IDataModel dataModel, SessionBeanElement typeElement) {
        SessionBeanAnnotations.TransactionManagementAnnotation tma = typeElement.getTransactionMgmtAnnotation();
        if (typeElement.getStatefulAnnotation().hasAnnotation() && typeElement.hasExplicitCommit()) {
            if (tma != null && tma.isBean()) {
                dataModel.setStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE", TransactionType.BEAN_EXPLICIT.toString());
                return;
            }
            SessionBeanAnnotations.TransactionAttributeAnnotation taa = typeElement.getTransactionAttrAnnotation();
            if (taa.isNotSupported()) {
                dataModel.setStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE", TransactionType.CONTAINER_EXPLICIT.toString());
                return;
            }
        }
        if (tma.isBean()) {
            dataModel.setStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE", TransactionType.BEAN_IMPLICIT.toString());
            return;
        }
        dataModel.setStringProperty("IServiceDefinitionDataModelProperties.TRANSACTION_TYPE", TransactionType.CONTAINER_IMPLICIT.toString());
    }

    /*
     * Exception decompiling
     */
    private static String findServiceDefinitionId(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String extractDesignTimeId(String text) {
        String s;
        Matcher matcher = DT_ID_PATTERN.matcher(text.trim());
        if (matcher.matches() && (s = matcher.group(2)) != null) {
            return s.trim();
        }
        return null;
    }

    public static class GeneratedSessionBean {
        private final SessionBean _sessionBean;

        public GeneratedSessionBean(SessionBean sessionBean) {
            this._sessionBean = sessionBean;
        }

        public SessionBean getSessionBean() {
            return this._sessionBean;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this._sessionBean == null ? 0 : this._sessionBean.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof GeneratedSessionBean)) {
                return false;
            }
            GeneratedSessionBean other = (GeneratedSessionBean)obj;
            return !(this._sessionBean == null ? other._sessionBean != null : !this._sessionBean.equals(other._sessionBean));
        }

        public String toString() {
            if (this._sessionBean != null) {
                return this._sessionBean.getEjbClass();
            }
            return "<null SessionBean>";
        }
    }
}

