/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.utils;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.view.appgen.utils.SessionBeanAnnotations;
import oracle.eclipse.tools.adf.view.appgen.utils.TypeElement;

public class SessionBeanElement
extends TypeElement {
    private SessionBeanAnnotations.StatelessAnnotation statelessAnnotation;
    private SessionBeanAnnotations.StatefulAnnotation statefulAnnotation;
    private SessionBeanAnnotations.SingletonAnnotation singletonAnnotation;
    private SessionBeanAnnotations.TransactionManagementAnnotation transactionAnnotation;
    private SessionBeanAnnotations.TransactionAttributeAnnotation transactionAttrAnnotation;
    private SessionBeanAnnotations.ConcurrencyAnnotation concurrencyAnnotation;
    private List<MethodElement> methodElements;

    public SessionBeanElement(TypeDeclaration typeDeclaration) {
        super(typeDeclaration);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.statelessAnnotation = new SessionBeanAnnotations.StatelessAnnotation((Declaration)this.getTypeDeclaration());
        this.statefulAnnotation = new SessionBeanAnnotations.StatefulAnnotation((Declaration)this.getTypeDeclaration());
        this.singletonAnnotation = new SessionBeanAnnotations.SingletonAnnotation((Declaration)this.getTypeDeclaration());
        this.transactionAnnotation = new SessionBeanAnnotations.TransactionManagementAnnotation((Declaration)this.getTypeDeclaration());
        this.transactionAttrAnnotation = new SessionBeanAnnotations.TransactionAttributeAnnotation((Declaration)this.getTypeDeclaration());
        this.concurrencyAnnotation = new SessionBeanAnnotations.ConcurrencyAnnotation((Declaration)this.getTypeDeclaration());
        this.methodElements = new ArrayList<MethodElement>();
        Collection<? extends MethodDeclaration> methods = this.getMethodDeclarations();
        for (MethodDeclaration methodDeclaration : methods) {
            this.methodElements.add(new MethodElement(this, methodDeclaration));
        }
    }

    @Override
    public String getSimpleName() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getSimpleName();
        }
        return "";
    }

    public SessionBeanAnnotations.StatelessAnnotation getStatelessAnnotation() {
        return this.statelessAnnotation;
    }

    public SessionBeanAnnotations.StatefulAnnotation getStatefulAnnotation() {
        return this.statefulAnnotation;
    }

    public SessionBeanAnnotations.SingletonAnnotation getSingletonAnnotation() {
        return this.singletonAnnotation;
    }

    public SessionBeanAnnotations.TransactionManagementAnnotation getTransactionMgmtAnnotation() {
        return this.transactionAnnotation;
    }

    public SessionBeanAnnotations.TransactionAttributeAnnotation getTransactionAttrAnnotation() {
        return this.transactionAttrAnnotation;
    }

    public SessionBeanAnnotations.ConcurrencyAnnotation getConcurrencyAnnotation() {
        return this.concurrencyAnnotation;
    }

    public List<MethodElement> getMethodElements() {
        return this.methodElements;
    }

    private Collection<? extends MethodDeclaration> getMethodDeclarations() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getMethods();
        }
        return Collections.emptyList();
    }

    public List<MethodElement> findExcludeClassInterceptorsMethods() {
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
        for (MethodElement method : this.methodElements) {
            if (!method.getExcludeClassInterceptorsAnnotation().hasAnnotation()) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<MethodElement> findTransactionAttributeMethods() {
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
        for (MethodElement method : this.methodElements) {
            if (!method.getTransactionAttributeAnnotation().hasAnnotation()) continue;
            methods.add(method);
        }
        return methods;
    }

    public static final class MethodElement {
        private final MethodDeclaration methodDeclaration;
        private SessionBeanAnnotations.ExcludeClassInterceptorsAnnotation excludeClassInterceptorAnnotation;
        private SessionBeanAnnotations.TransactionAttributeAnnotation transactionAttrAnnotation;

        public MethodElement(TypeElement parent, MethodDeclaration methodDeclaration) {
            this.methodDeclaration = methodDeclaration;
            this.initialize();
        }

        protected void initialize() {
            this.excludeClassInterceptorAnnotation = new SessionBeanAnnotations.ExcludeClassInterceptorsAnnotation((Declaration)this.getMethodDeclaration());
            this.transactionAttrAnnotation = new SessionBeanAnnotations.TransactionAttributeAnnotation((Declaration)this.getMethodDeclaration());
        }

        public MethodDeclaration getMethodDeclaration() {
            return this.methodDeclaration;
        }

        public SessionBeanAnnotations.ExcludeClassInterceptorsAnnotation getExcludeClassInterceptorsAnnotation() {
            return this.excludeClassInterceptorAnnotation;
        }

        public SessionBeanAnnotations.TransactionAttributeAnnotation getTransactionAttributeAnnotation() {
            return this.transactionAttrAnnotation;
        }
    }
}

