/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.utils;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.util.JPAUtils;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.jpa.core.context.Entity;

public class EntityUtil {
    private static final String DEFAULT_PKG = "";

    public static List<String> getClassEntityNames(IProject project, String classname) {
        ArrayList<String> entities = new ArrayList<String>();
        List projectEntities = JPAUtils.getEntities((IProject)project);
        if (projectEntities.isEmpty()) {
            return entities;
        }
        ArrayList<String> potentialMatches = new ArrayList<String>();
        ArrayList<String> projectEntityNames = new ArrayList<String>();
        String pkg = ClassUtil.getPackageName((String)classname);
        if (pkg == null) {
            pkg = DEFAULT_PKG;
        }
        for (Entity entity : projectEntities) {
            String entityName = entity.getPersistentType().getName();
            projectEntityNames.add(entityName);
            String entityPkg = ClassUtil.getPackageName((String)entityName);
            if (entityPkg == null) {
                entityPkg = DEFAULT_PKG;
            }
            if (!pkg.equals(entityPkg)) continue;
            potentialMatches.add(entityName);
        }
        IJavaProject javaProject = JavaUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                IType type = javaProject.findType(classname);
                if (type != null) {
                    IMethod[] methods;
                    int i;
                    IImportDeclaration[] imports;
                    ICompilationUnit cu = type.getCompilationUnit();
                    if (cu != null && (imports = cu.getImports()) != null) {
                        i = 0;
                        while (i < imports.length) {
                            if (projectEntityNames.contains(imports[i].getElementName())) {
                                potentialMatches.add(imports[i].getElementName());
                            }
                            ++i;
                        }
                    }
                    if ((methods = type.getMethods()) != null) {
                        i = 0;
                        while (i < methods.length) {
                            IAnnotation anno = methods[i].getAnnotation("generated");
                            if (anno != null) {
                                String methodName = methods[i].getElementName();
                                String entityName = null;
                                if (methodName.startsWith("persist")) {
                                    entityName = methodName.substring(7);
                                } else if (methodName.startsWith("merge")) {
                                    entityName = methodName.substring(5);
                                }
                                if (entityName != null) {
                                    for (String name : potentialMatches) {
                                        if (!entityName.equals(ClassUtil.getClassName((String)name))) continue;
                                        if (entities.contains(name)) break;
                                        entities.add(name);
                                        break;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (JavaModelException jme) {
                LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (CoreException)((Object)jme));
            }
        }
        return entities;
    }
}

