/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.templating;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.appgen.appspec.IEntityInfo;
import oracle.eclipse.tools.common.services.appgen.templating.AbstractTemplateBean;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;

public class EntityTemplateBean
extends AbstractTemplateBean {
    private static final String ID = "entity";
    private final IEntityInfo _entityInfo;

    public EntityTemplateBean(IEntityInfo entityInfo) {
        this._entityInfo = entityInfo;
        if (this._entityInfo == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Entity info is null");
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            throw iae;
        }
    }

    public String getContextID() {
        return ID;
    }

    public String getDisplayName() {
        return this._entityInfo.getName();
    }

    public String getClassName() {
        return this._entityInfo.getEntity().getPersistentType().getName();
    }

    public String getSimpleName() {
        return this._entityInfo.getEntity().getPersistentType().getSimpleName();
    }

    public String getPackage() {
        return ClassUtil.getPackageName((String)this.getClassName());
    }

    public String getSimpleNameAsField() {
        String name = this.getSimpleName();
        return String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
    }

    public List<String> getAttributes() {
        ArrayList<String> attrs = new ArrayList<String>();
        for (IEntityInfo.IAttribute iAttribute : this._entityInfo.getPersistentAttributeInfo()) {
            attrs.add(iAttribute.getName());
        }
        return attrs;
    }

    public List<String> getDisplayColumns() {
        return this.getAttributes();
    }
}

