/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.generators.internal;

import com.bea.wlw.template.ITemplateBean;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.eclipse.tools.adf.view.appgen.appspec.IEntityInfo;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.AbstractServiceGenerationContextFactory;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.ArtifactNames;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.JavaServiceNamedQueryMethodBuilder;
import oracle.eclipse.tools.adf.view.appgen.generators.internal.JavaServiceRemoveMethodBuilder;
import oracle.eclipse.tools.adf.view.appgen.templating.EntityTemplateBean;
import oracle.eclipse.tools.adf.view.appgen.templating.JavaServiceTemplateBean;
import oracle.eclipse.tools.common.services.appgen.generators.DefaultContext;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContext;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationParticipant;
import oracle.eclipse.tools.common.services.appgen.templating.AbstractTemplateBean;
import oracle.eclipse.tools.common.services.appgen.utils.IJavaProjectFileProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.jpa.core.context.NamedQuery;

public class JavaServiceFromEntitiesGenContextFactory
extends AbstractServiceGenerationContextFactory {
    private static final String JAVA_UTIL_LIST_TYPE = "java.util.List";
    private final IJavaProjectFileProvider _fileProvider;
    private JavaServiceTemplateBean _javaServiceTB;

    public JavaServiceFromEntitiesGenContextFactory(IServiceDefinitionInfo sdInfo, IJavaProjectFileProvider modelFileProvider) {
        super(sdInfo);
        this._fileProvider = modelFileProvider;
    }

    public List<IGenerationContext> getGenerationContexts() throws GenerationException {
        ArrayList<IGenerationContext> contexts = new ArrayList<IGenerationContext>();
        this.addJavaServiceContext(contexts);
        return contexts;
    }

    private void addJavaServiceContext(List<IGenerationContext> contexts) {
        JavaServiceTemplateBean javaServiceTB = this.getJavaServiceTemplateBean();
        String classname = javaServiceTB.getClassName();
        String desc = String.format(ArtifactNames.JAVA_SERVICE, classname);
        IFile targetFile = this._fileProvider.getJavaFile(classname);
        DefaultContext context = new DefaultContext(desc, targetFile, "oracle.eclipse.tools.adf.view.appgen.templating.javaService");
        context.addContextObject((ITemplateBean)javaServiceTB);
        contexts.add((IGenerationContext)context);
    }

    private JavaServiceTemplateBean getJavaServiceTemplateBean() {
        if (this._javaServiceTB == null) {
            this._javaServiceTB = JavaServiceFromEntitiesGenContextFactory.getJavaServiceTemplateBean(this.getServiceDefinitionInfo());
        }
        return this._javaServiceTB;
    }

    static JavaServiceTemplateBean getJavaServiceTemplateBean(IServiceDefinitionInfo sdInfo) {
        if (sdInfo == null) {
            return null;
        }
        StringBuilder fullNameBuilder = new StringBuilder(256);
        String beanName = sdInfo.getSessionBeanName();
        String pkg = sdInfo.getSessionBeanPackage();
        if (beanName == null || beanName.isEmpty()) {
            return null;
        }
        if (pkg != null && !pkg.isEmpty()) {
            fullNameBuilder.append(pkg);
            fullNameBuilder.append('.');
        }
        fullNameBuilder.append(beanName);
        String classname = fullNameBuilder.toString();
        JavaServiceTemplateBean javaServiceTB = new JavaServiceTemplateBean(classname);
        javaServiceTB.setDataModel(sdInfo.getDataModel());
        String designTimeId = JavaServiceFromEntitiesGenContextFactory.getDesignTimeId(sdInfo);
        if (designTimeId != null) {
            javaServiceTB.setDesignTimeId(designTimeId);
        }
        boolean needPUName = true;
        for (IEntityInfo iEntityInfo : sdInfo.getEntityInfoList()) {
            EntityTemplateBean entityTB = new EntityTemplateBean(iEntityInfo);
            entityTB.setDesignTimeId(designTimeId);
            javaServiceTB.addEntity(entityTB);
            JavaServiceFromEntitiesGenContextFactory.addRemoveMethodForEntity(javaServiceTB, iEntityInfo, entityTB);
            JavaServiceFromEntitiesGenContextFactory.addNamedQueryMethods(javaServiceTB, iEntityInfo, entityTB);
            if (!needPUName) continue;
            javaServiceTB.setPersistenceUnitName(JavaServiceFromEntitiesGenContextFactory.getPersistenceUnitName(iEntityInfo));
            needPUName = false;
        }
        return javaServiceTB;
    }

    private static void addRemoveMethodForEntity(JavaServiceTemplateBean sessionBeanTB, IEntityInfo entityInfo, EntityTemplateBean entityTB) {
        JavaServiceRemoveMethodBuilder removeMethod = new JavaServiceRemoveMethodBuilder(sessionBeanTB, entityInfo, entityTB);
        removeMethod.init();
        sessionBeanTB.addEntityMethod(entityTB, removeMethod);
    }

    private static void addNamedQueryMethods(JavaServiceTemplateBean sessionBeanTB, IEntityInfo entityInfo, EntityTemplateBean entityTB) {
        ListIterator<? extends NamedQuery> namedQueries = entityInfo.getNamedQueryObjects();
        if (namedQueries != null && namedQueries.hasNext()) {
            sessionBeanTB.addImport(JAVA_UTIL_LIST_TYPE);
            while (namedQueries.hasNext()) {
                NamedQuery query = namedQueries.next();
                JavaServiceNamedQueryMethodBuilder namedQueryMethod = new JavaServiceNamedQueryMethodBuilder(entityTB, query, entityInfo.getJpaProject());
                sessionBeanTB.addEntityMethod(entityTB, namedQueryMethod);
            }
        }
    }

    private static String getPersistenceUnitName(IEntityInfo entityInfo) {
        String puName = entityInfo.getEntity().getPersistenceUnit().getName();
        if (puName == null) {
            puName = "";
        }
        return puName;
    }

    public List<IGenerationParticipant> getGenerationParticipants() {
        return null;
    }

    public static class InterfaceInfoTemplateBean
    extends AbstractTemplateBean {
        private static final String ID = "interfaceInfo";
        private final boolean _isRemote;

        public InterfaceInfoTemplateBean(boolean isRemote) {
            this._isRemote = isRemote;
        }

        public String getContextID() {
            return ID;
        }

        public boolean isRemote() {
            return this._isRemote;
        }
    }
}

