/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.appspec.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.appgen.appspec.IEntityInfo;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.appgen.appspec.internal.EntityInfo;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JpaContextModelRoot;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ServiceDefinitionInfo
implements IServiceDefinitionInfo {
    private final IServiceDefinition serviceDefn;
    private final List<IEntityInfo> entityInfoList = new ArrayList<IEntityInfo>();
    private IDataModel dataModel;
    private String sessionBeanName;
    private String sessionBeanPkg;
    private String managedBeanName;
    private String managedBeanPkg;
    private String managedBeanProjectName;

    public ServiceDefinitionInfo(IServiceDefinition sd) {
        if (sd == null) {
            String message = "Program Error: Service Definition is null";
            IllegalArgumentException iae = new IllegalArgumentException(message);
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view", (Throwable)iae);
            throw iae;
        }
        this.serviceDefn = sd;
        this.constructEntityModel();
    }

    @Override
    public String getSessionBeanName() {
        return this.sessionBeanName;
    }

    @Override
    public IProject getSessionBeanProject() {
        return this.getProject(this.serviceDefn.getJpaProjectName());
    }

    @Override
    public String getSessionBeanPackage() {
        return this.sessionBeanPkg;
    }

    @Override
    public String getManagedBeanName() {
        return this.managedBeanName;
    }

    @Override
    public IProject getManagedBeanProject() {
        return this.getProject(this.managedBeanProjectName);
    }

    @Override
    public String getManagedBeanPackage() {
        return this.managedBeanPkg;
    }

    @Override
    public List<String> getEntityNames() {
        return this.serviceDefn.getEntityNames();
    }

    @Override
    public List<? extends IEntityInfo> getEntityInfoList() {
        return this.entityInfoList;
    }

    @Override
    public void setSessionBeanInfo(String sessionBeanName, String sessionBeanPackage) {
        this.setSessionBeanName(sessionBeanName);
        this.setSessionBeanPackage(sessionBeanPackage);
    }

    @Override
    public void setSessionBeanInfo(String sessionBeanName, String sessionBeanPackage, IDataModel dataModel) {
        this.setSessionBeanName(sessionBeanName);
        this.setSessionBeanPackage(sessionBeanPackage);
        this.setDataModel(dataModel);
    }

    @Override
    public void setManagedBeanInfo(String managedBeanName, String managedBeanPackage, String managedBeanProjectName) {
        this.setManagedBeanName(managedBeanName);
        this.setManagedBeanPackage(managedBeanPackage);
        this.setManagedBeanProjectName(managedBeanProjectName);
    }

    private void setSessionBeanName(String name) {
        this.sessionBeanName = name;
    }

    private void setSessionBeanPackage(String pkg) {
        this.sessionBeanPkg = pkg;
    }

    private void setManagedBeanName(String name) {
        this.managedBeanName = name;
    }

    private void setManagedBeanProjectName(String name) {
        this.managedBeanProjectName = name;
    }

    private void setManagedBeanPackage(String pkg) {
        this.managedBeanPkg = pkg;
    }

    @Override
    public IDataModel getDataModel() {
        return this.dataModel;
    }

    private void setDataModel(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void dump() {
        for (String name : this.getEntityNames()) {
            System.out.println("Entity Name = " + name);
        }
    }

    private void constructEntityModel() {
        String jpaProjectName = this.serviceDefn.getJpaProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(jpaProjectName);
        JpaProject jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
        JpaContextModelRoot rootContextNode = jpaProject.getContextModelRoot();
        PersistenceUnit pu1 = (PersistenceUnit)rootContextNode.getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        for (String entityName : this.getEntityNames()) {
            Entity entity = pu1.getEntity(entityName);
            if (entity == null) continue;
            this.entityInfoList.add(new EntityInfo(entity, jpaProject));
        }
    }

    private IProject getProject(String projectName) {
        if (projectName != null && !projectName.isEmpty()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return root.getProject(projectName);
        }
        return null;
    }
}

