/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.appgen.appspec.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.eclipse.tools.adf.view.appgen.appspec.IEntityInfo;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.QueryContainer;

public class EntityInfo
implements IEntityInfo {
    private Entity entity;
    private JpaProject jpaProject;

    public EntityInfo(Entity entity, JpaProject project) {
        this.entity = entity;
        this.jpaProject = project;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public String getName() {
        return this.entity.getName();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.entity.getPrimaryKeyColumnName();
    }

    @Override
    public String getTableName() {
        return this.entity.getPrimaryTableName();
    }

    @Override
    public ListIterator<? extends NamedQuery> getNamedQueryObjects() {
        QueryContainer queryCont = this.entity.getQueryContainer();
        return queryCont != null ? queryCont.getNamedQueries().iterator() : null;
    }

    @Override
    public List<String> getNamedQueryStrings() {
        QueryContainer queryCont = this.entity.getQueryContainer();
        if (queryCont == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        ListIterator namedQueries = queryCont.getNamedQueries().iterator();
        if (namedQueries != null) {
            while (namedQueries.hasNext()) {
                NamedQuery query = (NamedQuery)namedQueries.next();
                list.add(query.getQuery());
            }
        }
        return list;
    }

    @Override
    public Iterator<PersistentAttribute> getPersistentAttributes() {
        PersistentType persistentType = this.entity.getPersistentType();
        return persistentType != null ? persistentType.getAllAttributes().iterator() : null;
    }

    @Override
    public List<? extends IEntityInfo.IAttribute> getPersistentAttributeInfo() {
        Iterator persAttrs;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        PersistentType persistentType = this.entity.getPersistentType();
        if (persistentType != null && (persAttrs = persistentType.getAllAttributes().iterator()) != null) {
            while (persAttrs.hasNext()) {
                PersistentAttribute pa = (PersistentAttribute)persAttrs.next();
                attrs.add(new Attribute(pa.getName(), pa.getTypeName()));
            }
        }
        return attrs;
    }

    public void dump() {
        System.out.println("======================================");
        System.out.println("Entity Name = " + this.getName());
        System.out.println("Table Name = " + this.getTableName());
        System.out.println("primary key = " + this.getPrimaryKeyColumnName());
        for (IEntityInfo.IAttribute iAttribute : this.getPersistentAttributeInfo()) {
            System.out.println("Attribute  = " + iAttribute.getName() + " Type = " + iAttribute.getTypeName());
        }
        for (String string : this.getNamedQueryStrings()) {
            System.out.println("Query = " + string);
        }
    }

    public static class Attribute
    implements IEntityInfo.IAttribute {
        private String name;
        private String type;

        public Attribute(String name, String type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeName() {
            return this.type;
        }
    }
}

