/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.model.internal.validation;

import oracle.eclipse.tools.adf.model.document.ADFmJavaBeanConfigTypeFilter;
import oracle.eclipse.tools.adf.model.internal.validation.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ADFXmlFilesValidator
extends AbstractValidator
implements IValidator {
    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource == null || resource.getType() != 1) {
            return null;
        }
        IProject iproject = resource.getProject();
        IFolder adfmSrcFolder = iproject.getFolder("adfmsrc");
        if (!adfmSrcFolder.exists()) {
            return null;
        }
        IFile file = (IFile)resource;
        IJavaProject javaProject = JavaCore.create((IProject)iproject);
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        String ext = file.getFileExtension();
        if (ext != null && ext.equalsIgnoreCase("java")) {
            if (kind == 1 || kind == 8192) {
                this.validateAllXMLFiles(file, javaProject, reporter);
            }
        } else if (ext != null && ext.equalsIgnoreCase("xml")) {
            String fullPath = file.getFullPath().toString();
            if (fullPath.indexOf("/adfmsrc/") == -1) {
                return null;
            }
            this.checkIfXMLHasJavaCounterpart(file, javaProject, reporter);
        }
        return result;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
    }

    public void clean(IProject project, ValidationState state, IProgressMonitor monitor) {
    }

    private void validateAllXMLFiles(IFile javaFile, final IJavaProject javaProject, final IReporter reporter) {
        IProject proj = javaFile.getProject();
        IFolder srcFolder = proj.getFolder("adfmsrc");
        if (srcFolder != null && srcFolder.exists()) {
            try {
                srcFolder.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IContainer) {
                            return true;
                        }
                        if (resource instanceof IFile && ((IFile)resource).getFileExtension().equals("xml")) {
                            ADFXmlFilesValidator.this.checkIfXMLHasJavaCounterpart((IFile)resource, javaProject, reporter);
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkIfXMLHasJavaCounterpart(IFile xmlFile, IJavaProject javaProject, IReporter reporter) {
        String xmlFileName = xmlFile.getName();
        if (xmlFileName.equals("adfm.xml") || xmlFileName.equals("UpdateableCollection.xml") || xmlFileName.equals("UpdateableSingleValue.xml")) {
            return;
        }
        if (!ADFmJavaBeanConfigTypeFilter.getInstance().match((IResource)xmlFile)) {
            return;
        }
        if (javaProject == null) {
            return;
        }
        try {
            IPackageFragmentRoot[] pkgFragRoots = javaProject.getPackageFragmentRoots();
            boolean found = false;
            if (pkgFragRoots != null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = pkgFragRoots;
                int n = pkgFragRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot pfr = iPackageFragmentRootArray[n2];
                    if (pfr.getKind() == 1 && (found = this.checkForJavaFile((IContainer)pfr.getCorrespondingResource(), xmlFile, reporter))) break;
                    ++n2;
                }
            }
            if (!found) {
                String message = String.valueOf(Messages.ADFXmlFilesValidator_msg1) + xmlFile.getName() + Messages.ADFXmlFilesValidator_msg2;
                LocalizedMessage msg = new LocalizedMessage(2, message, (IResource)xmlFile);
                msg.setOffset(0);
                msg.setLength(1);
                msg.setLineNo(1);
                reporter.addMessage((IValidator)this, (IMessage)msg);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private boolean checkForJavaFile(IContainer container, IFile xmlFile, IReporter reporter) {
        IFile file;
        IPath xmlpath = xmlFile.getProjectRelativePath().removeFirstSegments(1).removeFileExtension();
        boolean foundFolders = true;
        IContainer folder = container;
        int i = 0;
        int count = xmlpath.segmentCount();
        while (i < count - 1) {
            String segment = xmlpath.segment(i);
            IFolder newfolder = folder.getFolder((IPath)new Path(segment));
            if (!folder.exists()) {
                foundFolders = false;
                break;
            }
            folder = newfolder;
            ++i;
        }
        return foundFolders && (file = folder.getFile((IPath)new Path(String.valueOf(xmlpath.lastSegment()) + ".java"))).exists();
    }
}

