/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.model.internal.technology;

import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.common.services.project.IProjectSharedEventManager;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryEvent;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ADFmTechnologyDiscoverer
extends AbstractTechnologyDiscoverer
implements IProjectSharedEventManager.IProjectSharedEventListener {
    private IFile adfXmlFile;

    public ADFmTechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
        super(technologyDiscoveryProvider, techId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive() {
        Project project = this.getTechnologyDiscoveryProvider().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project.getEclipseProject());
        if (javaProject == null) return false;
        if (!javaProject.exists()) return false;
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (true) {
                IResource findMember;
                IFolder folder;
                if (n2 >= n) {
                    return false;
                }
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IResource underlyingResource = root.getUnderlyingResource();
                if (underlyingResource != null && underlyingResource.getType() == 2 && underlyingResource.exists() && (folder = (IFolder)underlyingResource).getProject().equals((Object)project.getEclipseProject()) && (findMember = folder.findMember("/META-INF/adfm.xml")) != null && findMember.getType() == 1) {
                    this.adfXmlFile = (IFile)findMember;
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ADFPlugin.log(e);
        }
        return false;
    }

    public void start() {
        this.getTechnologyDiscoveryProvider().getProject().addSharedEventListener((IProjectSharedEventManager.IProjectSharedEventListener)this);
    }

    public void stop() {
        this.getTechnologyDiscoveryProvider().getProject().removeSharedEventListener((IProjectSharedEventManager.IProjectSharedEventListener)this);
    }

    public void resourceChanged(ISequentialResourceChangeEvent event) {
        if (this.adfXmlFile == null) {
            return;
        }
        Set resourceChanges = event.getResourceChanges();
        for (IResourceChange change : resourceChanges) {
            IResource resource = change.getResource();
            if (resource == null || resource.getType() != 1 || change.getKind() != IResourceChange.KIND.ADDED && change.getKind() != IResourceChange.KIND.REMOVED || resource.isPhantom() || resource.isTeamPrivateMember() || resource.isDerived() || !resource.getProjectRelativePath().toString().equals(this.adfXmlFile.getProjectRelativePath())) continue;
            ADFmRegistryEvent discEv = new ADFmRegistryEvent(change);
            this.notifyListeners(discEv);
        }
    }

    public void facetedProjectStatusChanged(boolean projectIsFaceted) {
    }

    private class ADFmRegistryEvent
    implements ITechnologyDiscoveryEvent {
        private IResourceChange _delta;

        public ADFmRegistryEvent(IResourceChange delta) {
            this._delta = delta;
        }

        public ITechnologyDiscoveryEvent.Type getType() {
            assert (this._delta != null);
            if (this._delta == null || this._delta.getKind() == IResourceChange.KIND.ADDED) {
                return ITechnologyDiscoveryEvent.Type.ADDED;
            }
            if (this._delta.getKind() == IResourceChange.KIND.REMOVED) {
                return ITechnologyDiscoveryEvent.Type.REMOVED;
            }
            return ITechnologyDiscoveryEvent.Type.UNKNOWN;
        }

        public ITechnologyExtensionIdentifier getTechnology() {
            return ADFmTechnologyDiscoverer.this.getTechnologyId();
        }

        public ITechnologyDiscoverer getDiscoverer() {
            return ADFmTechnologyDiscoverer.this;
        }

        public Object getInitiatingEvent() {
            return null;
        }
    }
}

