/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.refactor.internal;

import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ArtifactRefactoringSelectionTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Object a;
        if (!"enabled".equals(property)) {
            return false;
        }
        if (receiver instanceof IStructuredSelection && (a = ((IStructuredSelection)receiver).getFirstElement()) instanceof IVirtualArtifact) {
            IVirtualArtifact artifact = (IVirtualArtifact)a;
            IFile file = (IFile)artifact.getLocation().getResource();
            if (file == null || !file.exists()) {
                return false;
            }
            ResourceLocation location = artifact.getBoundedLocation();
            if (location == null) {
                location = artifact.getLocation();
            }
            if (location == null || location.getRange() == null) {
                return false;
            }
            String rangeString = RefactoringUtil.getRangeString((IFile)file, (Range)location.getRange());
            String name = artifact.getName();
            if (rangeString == null || name == null) {
                return false;
            }
            Range replaceRange = RefactoringUtil.getReplaceRange((IFile)file, (Range)location.getRange(), (String)name);
            return replaceRange != null;
        }
        return false;
    }
}

