/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.refactor.internal;

import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ArtifactRefactoringEnablementTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IFileEditorInput fInput;
        IFile file;
        IEditorInput eInput;
        if (!"enabled".equals(property)) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return false;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (editor == null) {
            return false;
        }
        if (receiver instanceof ITextSelection && (eInput = editor.getEditorInput()) instanceof IFileEditorInput && (file = (fInput = (IFileEditorInput)eInput).getFile()) != null) {
            int offset = ((ITextSelection)receiver).getOffset();
            ResourceArtifact artifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)file);
            return this.hasArtifactDefinitionAtOffset(file, (IArtifact)artifact, offset);
        }
        return false;
    }

    private final boolean hasArtifactDefinitionAtOffset(IFile file, IArtifact artifact, int offset) {
        Set childArtrifacts = ArtifactControllerFactory.getController().getArtifactChildren(artifact);
        for (IArtifact childArtifact : childArtrifacts) {
            Range range;
            ResourceLocation childArtifactLocation;
            ResourceLocation resourceLocation = childArtifactLocation = childArtifact instanceof IVirtualArtifact ? ((IVirtualArtifact)childArtifact).getBoundedLocation() : childArtifact.getLocation();
            if (childArtifactLocation != null && file.equals((Object)childArtifactLocation.getResource()) && (range = childArtifactLocation.getRange()) != null && range.contains((long)offset)) {
                return true;
            }
            if (!this.hasArtifactDefinitionAtOffset(file, childArtifact, offset)) continue;
            return true;
        }
        Set references = artifact.getReferences();
        for (IArtifactReference reference : references) {
            IArtifact targetArtifact;
            if (!reference.isTargetDefinedByReferringSource() || !this.hasArtifactDefinitionAtOffset(file, targetArtifact = reference.getTargetArtifact(), offset)) continue;
            return true;
        }
        return false;
    }
}

