/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.quickfix;

import java.util.Collection;
import oracle.eclipse.tools.common.services.ui.Activator;
import oracle.eclipse.tools.common.services.ui.quickfix.AbstractQuickFixFactory;
import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixCatalogue;
import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixCatalogueIndex;
import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixExtensionLoader;
import oracle.eclipse.tools.common.services.ui.quickfix.ThreadSafeQuickFixCatalogue;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public class QuickFixCatalogueInstance {
    private static QuickFixCatalogue INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuickFixCatalogue getInstance() {
        Class<QuickFixCatalogueInstance> clazz = QuickFixCatalogueInstance.class;
        synchronized (QuickFixCatalogueInstance.class) {
            if (INSTANCE == null) {
                INSTANCE = new ThreadSafeQuickFixCatalogue(new QuickFixCatalogue());
                QuickFixExtensionLoader loader = new QuickFixExtensionLoader();
                for (final AbstractQuickFixFactory factory : loader.getExtensions()) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            Collection<? extends QuickFixCatalogueIndex> problems = factory.createQuickFixes();
                            for (QuickFixCatalogueIndex quickFixCatalogueIndex : problems) {
                                INSTANCE.addIndex(quickFixCatalogueIndex);
                            }
                        }

                        public void handleException(Throwable exception) {
                            Activator.log("While trying to load extension point for quick fix catalogue", exception);
                        }
                    });
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public QuickFixCatalogueIndex findByMarker(IMarker marker) {
        try {
            Object attribute = marker.getAttribute("oracle.eclipse.tools.KEY_CATALOGUED_INDEX");
            if (attribute instanceof String) {
                return QuickFixCatalogueInstance.getInstance().findByKey((String)attribute);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "oracle.eclipse.tools.common.services.ui", "finding index for marker", (Throwable)e));
        }
        return null;
    }
}

