/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.TypeReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceReference;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactLabelProvider;
import oracle.eclipse.tools.common.services.ui.hyperlink.IHyperlinkProvider;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.INavigationCaseProvider;
import oracle.eclipse.tools.common.services.util.NavigationCaseDocumentServiceFactory;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HyperlinkUtil {
    public static IHyperlink[] getLinksFromArtifact(IFile sourceFile, IArtifact artifact, int offset, IStructuredModel structuredModel, Node currentNode, ArtifactController controller, boolean hasCompatibleLinks) {
        if (Activator.getDefault().getPreferences().getProjectPreferences(sourceFile.getProject()).isDisabled()) {
            return null;
        }
        if (artifact != null) {
            ArtifactLabelProvider labelProvider = new ArtifactLabelProvider();
            HashSet<IHyperlink> hyperlinks = new HashSet<IHyperlink>();
            try {
                INavigationCaseProvider provider;
                IDOMAttr domAttr;
                String value;
                Node node;
                Node node2 = node = currentNode != null ? currentNode : HyperlinkUtil.getCurrentNode(structuredModel, offset);
                if (node instanceof IDOMAttr && (value = (domAttr = (IDOMAttr)node).getValue()) != null && (provider = NavigationCaseDocumentServiceFactory.getNavigationCaseProvider((IFile)sourceFile)) != null) {
                    int regionStart = domAttr.getValueRegionStartOffset();
                    String regionText = domAttr.getValueRegionText();
                    if (regionText != null && regionText.charAt(0) == '\"') {
                        ++regionStart;
                    }
                    Collection outcomes = NavigationCaseDocumentServiceFactory.filterByName((Collection)provider.getFromNavigationCases(), (String)value);
                    for (IArtifact outcome : outcomes) {
                        ResourceLocation location = outcome.getLocation();
                        if (location == null || location.getRange() == null) continue;
                        Region region = new Region(regionStart, value.length());
                        String linkText = location.getResource() instanceof IFile ? location.getResource().getName() : labelProvider.getText(outcome);
                        hyperlinks.add(new Hyperlink(location, (IRegion)region, linkText));
                    }
                }
            }
            catch (Exception exception) {}
            if (hyperlinks.isEmpty()) {
                Set artifactReferences = artifact.getReferences();
                Set<IArtifactReference> scopedReferences = HyperlinkUtil.getReferencesAt(sourceFile, offset, artifactReferences);
                for (IArtifactReference reference : scopedReferences) {
                    ResourceLocation location;
                    IRegion hyperLinkRegion;
                    Object hlProvider = Platform.getAdapterManager().getAdapter((Object)reference, IHyperlinkProvider.class);
                    if (hlProvider instanceof IHyperlinkProvider) {
                        hyperLinkRegion = HyperlinkUtil.getHyperlinkRegion(reference, offset, structuredModel, currentNode);
                        hyperlinks.addAll(((IHyperlinkProvider)hlProvider).getHyperlinks(hyperLinkRegion));
                        continue;
                    }
                    if (reference instanceof ResourceReference) {
                        ResourceReference resourceReference = (ResourceReference)reference;
                        IResource referedFile = resourceReference.getRefereeResource();
                        if (referedFile == null || !referedFile.isAccessible() || referedFile.getType() != 1) continue;
                        IRegion hyperLinkRegion2 = HyperlinkUtil.getHyperlinkRegion(reference, offset, structuredModel, currentNode);
                        if (hasCompatibleLinks) continue;
                        hyperlinks.add(new Hyperlink((IFile)referedFile, hyperLinkRegion2));
                        continue;
                    }
                    if (reference instanceof TypeReference) {
                        IType type = ((TypeReference)reference).getJavaType();
                        if (type == null || !type.exists()) continue;
                        IRegion hyperLinkRegion3 = HyperlinkUtil.getHyperlinkRegion(reference, offset, structuredModel, currentNode);
                        hyperlinks.add(new Hyperlink(type, hyperLinkRegion3));
                        continue;
                    }
                    hyperLinkRegion = HyperlinkUtil.getHyperlinkRegion(reference, offset, structuredModel, currentNode);
                    IArtifact targetArtifact = reference.getTargetArtifact();
                    if (targetArtifact == null || (location = targetArtifact.getLocation()) == null || location.getResource() == null || location.getResource().getType() != 1) continue;
                    hyperlinks.add(new Hyperlink(location, hyperLinkRegion, labelProvider.getText(reference)));
                }
                Set children = controller.getArtifactChildren(artifact);
                for (IArtifact child : children) {
                    IHyperlink[] childLinks;
                    if (!(child instanceof IVirtualArtifact) || (childLinks = HyperlinkUtil.getLinksFromArtifact(sourceFile, child, offset, structuredModel, currentNode, controller, hasCompatibleLinks)) == null || childLinks.length <= 0) continue;
                    hyperlinks.addAll(Arrays.asList(childLinks));
                }
                for (IArtifactReference reference : artifactReferences) {
                    IArtifact targetArtifact;
                    IHyperlink[] childLinks;
                    if (!reference.isTargetDefinedByReferringSource() || (childLinks = HyperlinkUtil.getLinksFromArtifact(sourceFile, targetArtifact = reference.getTargetArtifact(), offset, structuredModel, currentNode, controller, hasCompatibleLinks)) == null || childLinks.length <= 0) continue;
                    hyperlinks.addAll(Arrays.asList(childLinks));
                }
            }
            if (!hyperlinks.isEmpty()) {
                ArrayList list = new ArrayList(hyperlinks);
                Collections.sort(list, new Comparator<IHyperlink>(){

                    @Override
                    public int compare(IHyperlink o1, IHyperlink o2) {
                        int result = this.compare(o1.getHyperlinkText(), o2.getHyperlinkText());
                        if (result != 0) {
                            return result;
                        }
                        result = this.compare(o1.getTypeLabel(), o2.getTypeLabel());
                        if (result != 0) {
                            return result;
                        }
                        return 0;
                    }

                    @Override
                    private int compare(String s1, String s2) {
                        return ObjectUtil.equals((Object)s1, (Object)s2) ? 0 : (s1 == null ? 1 : (s2 == null ? -1 : s1.compareTo(s2)));
                    }
                });
                return list.toArray(new IHyperlink[list.size()]);
            }
        }
        return null;
    }

    private static IRegion getHyperlinkRegion(IArtifactReference reference, int offset, IStructuredModel structuredModel, Node currentNode) {
        Node node;
        ResourceLocation hyperLinkLocation = null;
        for (IArtifactReferenceLocation refLocation : reference.getLocations()) {
            Range range;
            ResourceLocation loc = refLocation.getResourceLocation();
            if (loc == null || (range = loc.getRange()) == null || (long)offset < range.getOffset() || (long)offset > range.getEndOffset()) continue;
            hyperLinkLocation = loc;
            break;
        }
        if (hyperLinkLocation != null) {
            return new Region((int)hyperLinkLocation.getRange().getOffset(), (int)hyperLinkLocation.getRange().getLength());
        }
        Node node2 = node = currentNode != null ? currentNode : HyperlinkUtil.getCurrentNode(structuredModel, offset);
        if (node instanceof IDOMAttr) {
            IDOMAttr att = (IDOMAttr)node;
            int regOffset = att.getValueRegionStartOffset();
            ITextRegion valueRegion = att.getValueRegion();
            if (valueRegion != null) {
                int regLength = valueRegion.getTextLength();
                String attValue = att.getValueRegionText();
                if (StringUtils.isQuoted((String)attValue)) {
                    ++regOffset;
                    regLength -= 2;
                }
                return new Region(regOffset, regLength);
            }
        } else if (node instanceof IDOMNode) {
            IDOMNode docNode = (IDOMNode)node;
            return new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
        }
        return null;
    }

    private static Node getCurrentNode(IStructuredModel structuredModel, int offset) {
        IndexedRegion inode = structuredModel.getIndexedRegion(offset);
        if (inode instanceof Node) {
            if (inode instanceof IDOMElement) {
                NamedNodeMap namedNodeMap = ((Node)inode).getAttributes();
                int i = 0;
                while (i < namedNodeMap.getLength()) {
                    IDOMAttr domAttr;
                    Node attr = namedNodeMap.item(i);
                    if (attr instanceof IDOMAttr && (domAttr = (IDOMAttr)attr).getValueRegionStartOffset() <= offset && offset < domAttr.getEndOffset()) {
                        return attr;
                    }
                    ++i;
                }
            }
            return (Node)inode;
        }
        return null;
    }

    private static Set<IArtifactReference> getReferencesAt(IFile source, int offset, Set<IArtifactReference> references) {
        HashSet<IArtifactReference> referencesAtOffset = new HashSet<IArtifactReference>();
        for (IArtifactReference reference : references) {
            for (IArtifactReferenceLocation referenceLocation : reference.getLocations()) {
                ResourceLocation resLoc = referenceLocation.getResourceLocation();
                if (resLoc == null || resLoc.getRange() == null || resLoc.getResource() == null || !resLoc.getResource().equals((Object)source) || !resLoc.getRange().contains((long)offset)) continue;
                referencesAtOffset.add(reference);
            }
        }
        return referencesAtOffset;
    }

    public static Collection<? extends String> getTargetIds(ITextViewer textViewer) {
        if (textViewer instanceof StructuredTextViewer) {
            PrivateViewerConfiguration baseConfiguration = new PrivateViewerConfiguration();
            return baseConfiguration.getHyperlinkDetectorTargets((ISourceViewer)((StructuredTextViewer)textViewer)).keySet();
        }
        return Collections.emptyList();
    }

    public static boolean hasCompatibleHyperlinks(AbstractHyperlinkDetector withDetector, ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        boolean hasCompatibleHyperlinks = false;
        Collection<? extends String> targetIds = HyperlinkUtil.getTargetIds(textViewer);
        if (!targetIds.isEmpty()) {
            HyperlinkDetectorDescriptor[] descriptors;
            HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = descriptors = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    HyperlinkDetectorDescriptor descriptor = hyperlinkDetectorDescriptorArray[n2];
                    if (targetIds.contains(descriptor.getTargetId())) {
                        IHyperlink[] links;
                        AbstractHyperlinkDetector detector = null;
                        try {
                            detector = descriptor.createHyperlinkDetector();
                        }
                        catch (CoreException e) {
                            oracle.eclipse.tools.common.services.ui.Activator.log("Creating hyperling detector failed", e);
                            break block6;
                        }
                        if (!detector.getClass().equals(withDetector.getClass()) && (links = detector.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks)) != null && links.length > 0) {
                            hasCompatibleHyperlinks = true;
                            break;
                        }
                    }
                }
                ++n2;
            }
        }
        return hasCompatibleHyperlinks;
    }

    private static class Hyperlink
    implements IHyperlink,
    IAdaptable {
        private final IFile file;
        private final Range range;
        private final IType type;
        private final IRegion region;
        private final String linkText;

        public Hyperlink(IFile file, IRegion region) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            this.file = file;
            this.range = null;
            this.region = region;
            this.linkText = null;
            this.type = null;
        }

        public Hyperlink(IType type, IRegion region) {
            if (type == null) {
                throw new IllegalArgumentException();
            }
            this.file = null;
            this.range = null;
            this.region = region;
            this.linkText = null;
            this.type = type;
        }

        public Hyperlink(ResourceLocation location, IRegion region, String linkText) {
            if (location == null || location.getResource() == null || location.getResource().getType() != 1) {
                throw new IllegalArgumentException();
            }
            this.file = (IFile)location.getResource();
            this.range = location.getRange();
            this.region = region;
            this.linkText = linkText;
            this.type = null;
        }

        public Object getAdapter(Class adapter) {
            return IFile.class == adapter ? this.file : null;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return this.linkText != null ? this.linkText : (this.file == null ? this.type.getFullyQualifiedName() : this.file.getFullPath().toString());
        }

        public void open() {
            try {
                IEditorPart editor;
                if (this.file != null && this.file.exists()) {
                    IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = null;
                    if (workbench != null) {
                        page = workbench.getActivePage();
                    }
                    if (page != null) {
                        IGotoMarker gotoMarker;
                        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)this.file, (boolean)true);
                        if (this.range != null && (gotoMarker = (IGotoMarker)editorPart.getAdapter(IGotoMarker.class)) != null) {
                            IMarker marker = this.file.createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", (int)this.range.getOffset());
                            marker.setAttribute("charEnd", (int)this.range.getEndOffset());
                            gotoMarker.gotoMarker(marker);
                        }
                    }
                } else if (this.type != null && this.type.exists() && (editor = JavaUI.openInEditor((IJavaElement)this.type)) != null) {
                    JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)this.type);
                }
            }
            catch (RuntimeException re) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)re);
            }
            catch (PartInitException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)((Object)e));
            }
            catch (JavaModelException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)((Object)e));
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)e);
            }
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public int hashCode() {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash((Object)this.file);
            hcu.hash((Object)this.range);
            hcu.hash((Object)this.type);
            hcu.hash((Object)this.region);
            hcu.hash((Object)this.linkText);
            return hcu.getHashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Hyperlink) {
                Hyperlink link = (Hyperlink)other;
                return this.file == null ? link.file == null : (this.file.equals((Object)link.file) && this.type == null ? link.type == null : (this.type.equals(link.type) && this.range == null ? link.range == null : (this.range.equals((Object)link.range) && this.region == null ? link.region == null : (this.region.equals(link.region) && this.linkText == null ? link.linkText == null : this.linkText.equals(link.linkText)))));
            }
            return false;
        }
    }

    static class PrivateViewerConfiguration
    extends StructuredTextViewerConfigurationXML {
        PrivateViewerConfiguration() {
        }

        public Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            return super.getHyperlinkDetectorTargets(sourceViewer);
        }
    }
}

