/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.prefs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.Preferences;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.transaction.TransactionService;
import oracle.eclipse.tools.common.services.ui.dependency.prefs.DependencyPreferencePage;
import oracle.eclipse.tools.common.services.ui.dependency.prefs.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class DependencyPropertyPage
extends DependencyPreferencePage
implements IWorkbenchPropertyPage {
    private IProject project;

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = element instanceof IProject ? (IProject)element : (IProject)element.getAdapter(IProject.class);
    }

    @Override
    protected boolean isDisableBeforeOverride() {
        return false;
    }

    @Override
    protected void updateWidgets() {
        super.updateWidgets();
        if (!Activator.getDefault().getPreferences().isProjectSpecificSettingAllowed() && this.getDisableButton() != null) {
            this.getDisableButton().setEnabled(false);
        }
    }

    @Override
    protected List<ITechnologyExtensionIdentifier> getTechExtensions() {
        Project prj = (Project)this.project.getAdapter(Project.class);
        Set techExtensions = prj.getTechnologyExtensions();
        ArrayList<ITechnologyExtensionIdentifier> techExtIds = new ArrayList<ITechnologyExtensionIdentifier>(techExtensions.size());
        for (ITechnologyExtension ite : techExtensions) {
            techExtIds.add(ite.getTechnologyExtensionIdentifier());
        }
        Collections.sort(techExtIds, new Comparator<ITechnologyExtensionIdentifier>(){

            @Override
            public int compare(ITechnologyExtensionIdentifier o1, ITechnologyExtensionIdentifier o2) {
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                return 0;
            }
        });
        return techExtIds;
    }

    @Override
    protected void addOverride(Composite techExtGroup) {
        new Label(techExtGroup, 0).setLayoutData((Object)new GridData());
        Link configLink = new Link(techExtGroup, 0);
        GridData layout = new GridData(128);
        configLink.setLayoutData((Object)layout);
        configLink.setText("<A>" + Messages.DependencyPropertyPage_WorkspaceSettingsLinkText + "</A>");
        configLink.addSelectionListener(new SelectionListener(){

            public void doLinkActivated(Link e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)DependencyPropertyPage.this.getShell(), (String)this.getPreferencePageID(), null, null).open();
                DependencyPropertyPage.this.updateWidgets();
            }

            private String getPreferencePageID() {
                return "DependencyPreferencePage";
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.doLinkActivated((Link)e.widget);
            }

            public void widgetSelected(SelectionEvent e) {
                this.doLinkActivated((Link)e.widget);
            }
        });
    }

    @Override
    protected boolean shouldEnableActions() {
        return super.shouldEnableActions() && Activator.getDefault().getPreferences().isProjectSpecificSettingAllowed();
    }

    @Override
    protected IRunnableWithProgress getRefreshRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ITransactionContext context = TransactionService.getInstance().createTransaction();
                try {
                    DependencyModelManager.getInstance().refresh(DependencyPropertyPage.this.project, monitor, context);
                }
                finally {
                    TransactionService.getInstance().commit(context, monitor);
                }
            }
        };
    }

    @Override
    protected Preferences getPreferences() {
        Preferences wsPrefs = Activator.getDefault().getPreferences();
        return wsPrefs.getProjectPreferences(this.project);
    }
}

