/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.parts;

import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditor;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditorMessages;
import oracle.eclipse.tools.common.services.ui.dependency.editor.action.CollapseAction;
import oracle.eclipse.tools.common.services.ui.dependency.editor.action.ExpandAction;
import oracle.eclipse.tools.common.services.ui.dependency.editor.action.OpenResourceLocationAction;
import oracle.eclipse.tools.common.services.ui.dependency.editor.action.ShowDependencyAction;
import oracle.eclipse.tools.common.services.ui.dependency.editor.figures.ArtifactNodeFigure;
import oracle.eclipse.tools.common.services.ui.dependency.editor.model.ArtifactNode;
import oracle.eclipse.tools.common.services.ui.dependency.editor.model.ArtifactNodeRelationship;
import oracle.eclipse.tools.common.services.ui.dependency.editor.model.DependencyEditorModel;
import oracle.eclipse.tools.common.services.ui.dependency.editor.parts.ArtifactNodeRelationshipPart;
import oracle.eclipse.tools.common.services.ui.dependency.editor.property.AbstractArtifactPropertySourceProviderFactory;
import oracle.eclipse.tools.common.services.ui.dependency.editor.property.ArtifactPropertySource;
import oracle.eclipse.tools.common.services.ui.dependency.editor.property.ArtifactPropertySourceProviderFactoryLoader;
import oracle.eclipse.tools.common.services.ui.dependency.editor.property.VirtualArtifactPropertySource;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditor;
import oracle.eclipse.tools.common.ui.diagram.model.IMenuProvider;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.parts.RootNodePart;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class ArtifactNodePart
extends RootNodePart {
    private Boolean _hasReferences;
    private Boolean _hasReferers;

    public ArtifactNodePart(NodeDiagramEditor editor) {
        super(editor);
    }

    public ArtifactNode getArtifactNode() {
        return (ArtifactNode)((Object)this.getModel());
    }

    public IArtifact getArtifact() {
        return this.getArtifactNode().getArtifact();
    }

    protected IFigure createFigure() {
        return new ArtifactNodeFigure(this, this.getArtifactNode());
    }

    public void performRequest(Request req) {
        if (req.getType().equals("open")) {
            ResourceLocation location = this.getArtifact().getLocation();
            OpenResourceLocationAction openAction = new OpenResourceLocationAction(location, DependencyEditorMessages.open, null);
            IFile file = null;
            if (location != null && location.getResource() instanceof IFile) {
                file = (IFile)location.getResource();
            }
            if (file != null && file.exists()) {
                openAction.run();
            }
        }
        super.performRequest(req);
    }

    public void addReferences() {
        DependencyEditorModel model = (DependencyEditorModel)this.getDiagramEditor().getModel();
        model.addReferences(this.getArtifactNode());
        this.getArtifactNode().setRightExpanded(true);
        this.refresh();
        this.refreshModel();
    }

    public void removeReferences() {
        DependencyEditorModel model = (DependencyEditorModel)this.getDiagramEditor().getModel();
        model.removeReferences((Node)this.getArtifactNode());
        this.getArtifactNode().setRightExpanded(false);
        this.refresh();
        this.refreshModel();
    }

    public void addReferers() {
        DependencyEditorModel model = (DependencyEditorModel)this.getDiagramEditor().getModel();
        model.addReferers(this.getArtifactNode());
        this.getArtifactNode().setLeftExpanded(true);
        this.refresh();
        this.refreshModel();
    }

    public void removeReferers() {
        DependencyEditorModel model = (DependencyEditorModel)this.getDiagramEditor().getModel();
        model.removeReferers((Node)this.getArtifactNode());
        this.getArtifactNode().setLeftExpanded(false);
        this.refresh();
        this.refreshModel();
    }

    private void refreshModel() {
        this.getDiagramEditor().getModelEditPart().refresh();
        this.getDiagramEditor().getModelEditPart().getFigure().invalidate();
        this.getDiagramEditor().getModelEditPart().getFigure().validate();
        this.getDiagramEditor().selectObject((Object)this.getArtifact());
    }

    public boolean hasReferences() {
        if (this._hasReferences == null) {
            DependencyEditorModel model = (DependencyEditorModel)this.getDiagramEditor().getModel();
            this._hasReferences = model.hasReferences(this.getArtifactNode()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._hasReferences;
    }

    public boolean hasReferers() {
        if (this._hasReferers == null) {
            DependencyEditorModel model = (DependencyEditorModel)this.getDiagramEditor().getModel();
            this._hasReferers = model.hasReferers(this.getArtifactNode()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._hasReferers;
    }

    public void deactivate() {
        if (this.getFigure() != null) {
            ((ArtifactNodeFigure)this.getFigure()).destroy();
        }
        super.deactivate();
    }

    public org.eclipse.draw2d.graph.Node newNodeForEditPart(Subgraph parent) {
        org.eclipse.draw2d.graph.Node n = new org.eclipse.draw2d.graph.Node((Object)this, parent);
        Dimension nodeD = this.getFigure().getPreferredSize(-1, -1);
        n.width = nodeD.width > 160 ? nodeD.width : 160;
        n.height = nodeD.height;
        n.setPadding(new Insets(6, 24, 6, 24));
        n.setRowConstraint(0);
        return n;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IMenuProvider.class) {
            return new ArtifactNodeMenuProvider();
        }
        if (adapter == IPropertySource.class) {
            for (AbstractArtifactPropertySourceProviderFactory factory : ArtifactPropertySourceProviderFactoryLoader.INSTANCE.getExtensions()) {
                IPropertySourceProvider provider = factory.createProvider(this.getArtifact());
                if (provider == null) continue;
                return provider.getPropertySource((Object)this.getArtifact());
            }
            if (this.getArtifact() instanceof IVirtualArtifact) {
                return new VirtualArtifactPropertySource(this.getArtifact());
            }
            return new ArtifactPropertySource(this.getArtifact());
        }
        return super.getAdapter(adapter);
    }

    private class ArtifactNodeMenuProvider
    implements IMenuProvider {
        private ArtifactNodeMenuProvider() {
        }

        public void buildContextMenu(IMenuManager menuMgr) {
            IMenuProvider menuProvider;
            ArtifactNodeRelationship relationship;
            ResourceLocation location = ArtifactNodePart.this.getArtifact().getLocation();
            OpenResourceLocationAction openAction = new OpenResourceLocationAction(location, DependencyEditorMessages.open, null);
            IFile file = null;
            if (location != null && location.getResource() instanceof IFile) {
                file = (IFile)location.getResource();
            }
            if (file == null || !file.exists()) {
                openAction.setEnabled(false);
            }
            menuMgr.add((IAction)openAction);
            menuMgr.add((IContributionItem)new Separator());
            DependencyEditor editor = (DependencyEditor)ArtifactNodePart.this.getDiagramEditor();
            ShowDependencyAction showDependencyAction = new ShowDependencyAction(editor, ArtifactNodePart.this.getArtifactNode().getArtifact());
            if (ArtifactNodePart.this.getArtifactNode().isFocal()) {
                showDependencyAction.setEnabled(false);
            }
            menuMgr.add((IAction)showDependencyAction);
            MenuManager referencesMenuMgr = new MenuManager(DependencyEditorMessages.reference_detail);
            referencesMenuMgr.setParent((IContributionManager)menuMgr);
            menuMgr.add((IContributionItem)referencesMenuMgr);
            for (Object conn : ArtifactNodePart.this.getSourceConnections()) {
                if (!(conn instanceof ArtifactNodeRelationshipPart) || !(relationship = ((ArtifactNodeRelationshipPart)((Object)conn)).getArtifactNodeRelationship()).isReferenceAtSrc() || (menuProvider = (IMenuProvider)relationship.getAdapter(IMenuProvider.class)) == null) continue;
                menuProvider.buildContextMenu((IMenuManager)referencesMenuMgr);
            }
            for (Object conn : ArtifactNodePart.this.getTargetConnections()) {
                if (!(conn instanceof ArtifactNodeRelationshipPart) || (relationship = ((ArtifactNodeRelationshipPart)((Object)conn)).getArtifactNodeRelationship()).isReferenceAtSrc() || (menuProvider = (IMenuProvider)relationship.getAdapter(IMenuProvider.class)) == null) continue;
                menuProvider.buildContextMenu((IMenuManager)referencesMenuMgr);
            }
            menuMgr.add((IContributionItem)new Separator());
            ExpandAction expandAction = new ExpandAction(ArtifactNodePart.this);
            ArtifactNode node = ArtifactNodePart.this.getArtifactNode();
            boolean expandEnabled = false;
            if (node.isShowLeftExpander() && ArtifactNodePart.this.hasReferers() && !node.isLeftExpanded() || node.isShowRightExpander() && ArtifactNodePart.this.hasReferences() && !node.isRightExpanded()) {
                expandEnabled = true;
            }
            expandAction.setEnabled(expandEnabled);
            menuMgr.add((IAction)expandAction);
            CollapseAction collapseAction = new CollapseAction(ArtifactNodePart.this);
            boolean collapseEnabled = false;
            if (node.isShowLeftExpander() && ArtifactNodePart.this.hasReferers() && node.isLeftExpanded() || node.isShowRightExpander() && ArtifactNodePart.this.hasReferences() && node.isRightExpanded()) {
                collapseEnabled = true;
            }
            collapseAction.setEnabled(collapseEnabled);
            menuMgr.add((IAction)collapseAction);
        }
    }
}

