/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.services.ui.Activator;
import oracle.eclipse.tools.common.services.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class OpenResourceLocationAction
extends Action {
    private static final String WTP_MODEL_PROVIDER = "org.eclipse.wst.sse.core.StructuredModelManager";
    private ResourceLocation _location;

    public OpenResourceLocationAction(ResourceLocation location) {
        this._location = location;
        this.setText(OpenResourceLocationAction.getDisplayText(location));
        this.setImageDescriptor(Activator.Images.LINK_IMAGE.getImageDescriptor());
    }

    public OpenResourceLocationAction(ResourceLocation location, String actionText, ImageDescriptor image) {
        this._location = location;
        this.setText(actionText);
        if (image != null) {
            this.setImageDescriptor(image);
        }
    }

    private static String getDisplayText(ResourceLocation location) {
        IResource res = location.getResource();
        if (res == null) {
            return "";
        }
        if (res.getType() == 1) {
            try {
                IFile file = (IFile)res;
                Range range = location.getRange();
                if (range != null) {
                    boolean isXml = !file.getName().endsWith(".java");
                    String label = null;
                    if (isXml) {
                        label = OpenResourceLocationAction.getTextFromModel(file, range);
                    }
                    if (label == null) {
                        String contents = OpenResourceLocationAction.getContents(((IFile)location.getResource()).getContents());
                        label = OpenResourceLocationAction.getTagText(contents, isXml, range);
                    }
                    if ("".equals(label)) {
                        label = location.getResource().getName();
                    }
                    label = StringUtil.collapseWhiteSpaces((String)label);
                    if ((label = StringUtil.truncate((String)label, (int)80)).contains("@")) {
                        label = label.concat("@");
                    }
                    return label;
                }
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)e);
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (Throwable)e);
            }
        }
        return location.getResource().getName();
    }

    private static String getTextFromModel(IFile file, Range range) {
        IVisitableDOMModel vModel = null;
        try {
            IndexedRegion inode;
            IDOMModel domModel;
            if (range != null && (vModel = StructuredModelFactory.getVisitableModelForRead((IFile)file, (String)WTP_MODEL_PROVIDER)) != null && (domModel = vModel.getModel()) != null && (inode = domModel.getIndexedRegion((int)range.getOffset())) instanceof IDOMNode) {
                IDOMNode node = (IDOMNode)inode;
                String string = node.getStartStructuredDocumentRegion().getText();
                return string;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            if (vModel != null) {
                vModel.dispose();
            }
        }
    }

    private static String getTagText(String contents, boolean isXml, Range range) {
        if (range.getLength() > 0L) {
            int offset = (int)range.getOffset();
            int endOffset = (int)range.getEndOffset();
            if (isXml) {
                int closeBracketOffset;
                int openBracketOffset = offset < contents.length() ? contents.substring(0, offset).lastIndexOf(60) : -1;
                int n = closeBracketOffset = endOffset < contents.length() ? contents.substring(endOffset - 1).indexOf(62) : -1;
                if (openBracketOffset == -1 || closeBracketOffset == -1) {
                    return "";
                }
                return contents.substring(openBracketOffset, closeBracketOffset + 1);
            }
            offset = Math.min(offset, contents.length());
            endOffset = Math.min(endOffset, contents.length());
            return contents.substring(offset, endOffset);
        }
        return "";
    }

    private static String getContents(InputStream in) throws IOException {
        String string;
        try {
            String s;
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[512];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.close();
            string = s = new String(out.toByteArray(), "UTF8");
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public void run() {
        IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (workbench != null) {
            page = workbench.getActivePage();
        }
        if (page != null) {
            try {
                IResource res = this._location.getResource();
                if (res instanceof IFile) {
                    IGotoMarker gotoMarker;
                    IFile file = (IFile)res;
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    Range range = this._location.getRange();
                    if (this._location.getRange() != null && (gotoMarker = (IGotoMarker)editorPart.getAdapter(IGotoMarker.class)) != null) {
                        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                        marker.setAttribute("charStart", range != null ? (int)range.getOffset() : -1);
                        marker.setAttribute("charEnd", range != null ? (int)range.getEndOffset() : -1);
                        gotoMarker.gotoMarker(marker);
                    }
                }
            }
            catch (PartInitException pe) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)((Object)pe));
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)e);
            }
        }
    }
}

