/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor.action;

import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditor;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditorInput;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditor;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenDependencyEditorCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstSelection;
        Object selectedArtifact;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (selectedArtifact = (firstSelection = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IArtifact ? (IArtifact)firstSelection : (firstSelection instanceof IAdaptable ? (IArtifact)((IAdaptable)firstSelection).getAdapter(IArtifact.class) : null)) != null) {
            IWorkbenchPage page;
            DependencyEditorInput input = new DependencyEditorInput((IArtifact)selectedArtifact);
            IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            if (workbenchWindow != null && (page = workbenchWindow.getActivePage()) != null) {
                String editorId = event.getParameter("oracle.eclipse.tools.common.services.ui.dependency.editor");
                IEditorPart editorPart = null;
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference partRef = iEditorReferenceArray[n2];
                    if (partRef.getId().equals(editorId)) {
                        editorPart = (IEditorPart)partRef.getPart(false);
                        break;
                    }
                    ++n2;
                }
                if (editorPart != null) {
                    page.bringToTop(editorPart);
                    if (editorPart instanceof DependencyEditor) {
                        ((DependencyEditor)editorPart).refreshNewArtifact((IArtifact)selectedArtifact);
                    }
                } else {
                    try {
                        editorPart = page.openEditor((IEditorInput)input, editorId);
                    }
                    catch (PartInitException e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.common.services.ui", (CoreException)((Object)e));
                    }
                }
                if (editorPart instanceof NodeDiagramEditor) {
                    ((NodeDiagramEditor)editorPart).selectObject(selectedArtifact);
                }
            }
        }
        return null;
    }
}

