/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.util.StringUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class DependencyFilter {
    private static final char SYSTEM_FILE_CHAR = '.';
    private List<String> _types;
    private List<String> _fileExtensions;
    private String _customFileExtensions;
    private List<String> _customFileExtensionsList;
    private boolean _grpAdfBindings;

    public List<String> getTypes() {
        return this._types;
    }

    public void setTypes(List<String> types) {
        this._types = types;
    }

    public List<String> getFileExtensions() {
        return this._fileExtensions;
    }

    public void setFileExtensions(List<String> fileExtensions) {
        this._fileExtensions = fileExtensions;
    }

    public String getCustomFileExtensions() {
        return this._customFileExtensions;
    }

    public void setCustomFileExtensions(String customFileExtensions) {
        this._customFileExtensions = customFileExtensions;
        this._customFileExtensionsList = StringUtil.split((String)this._customFileExtensions, (char)',', (boolean)true, new ArrayList());
    }

    public boolean getGroupADFBindings() {
        return this._grpAdfBindings;
    }

    public void setGroupADFBindings(boolean b) {
        this._grpAdfBindings = b;
    }

    private boolean isResourceFiltered(ResourceArtifact artifact) {
        IResource resource = artifact.getLocation().getResource();
        String fileExtension = resource.getFileExtension();
        if (this._fileExtensions != null) {
            for (String extension : this._fileExtensions) {
                if (!extension.equals(fileExtension)) continue;
                return true;
            }
        }
        if (this._customFileExtensionsList != null) {
            for (String extension : this._customFileExtensionsList) {
                if (!extension.equals(fileExtension)) continue;
                return true;
            }
        }
        return this.isIgnoreSystemFilePreference(resource.getProject()) && this.isSystemResource(resource);
    }

    private boolean isTypeFiltered(IArtifact artifact) {
        if (artifact != null) {
            String artifactType = artifact.getType();
            if (this._types != null) {
                for (String type : this._types) {
                    if (!artifactType.equals(type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFiltered(IArtifact artifact) {
        if (artifact instanceof ResourceArtifact && this.isResourceFiltered((ResourceArtifact)artifact)) {
            return true;
        }
        return this.isTypeFiltered(artifact);
    }

    private boolean isIgnoreSystemFilePreference(IProject project) {
        if (project == null) {
            return false;
        }
        return Activator.getDefault().getPreferences().getProjectPreferences(project).isIgnoreSystemFilePreference();
    }

    private boolean isSystemResource(IResource resource) {
        if (resource == null) {
            return false;
        }
        String name = resource.getName();
        return name != null && name.length() > 0 && name.charAt(0) == '.';
    }
}

