/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency.editor;

import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.DependencyModelEvent;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModelListener;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyContextMenuProvider;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyEditorInput;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyFilter;
import oracle.eclipse.tools.common.services.ui.dependency.editor.DependencyToolbarPane;
import oracle.eclipse.tools.common.services.ui.dependency.editor.model.DependencyEditorModel;
import oracle.eclipse.tools.common.services.ui.dependency.editor.parts.ArtifactNodePartFactory;
import oracle.eclipse.tools.common.ui.diagram.actions.GraphEditorExportToImageAction;
import oracle.eclipse.tools.common.ui.diagram.actions.GraphicalEditorPrintAction;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditor;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramToolbarPane;
import oracle.eclipse.tools.common.ui.diagram.model.NodeDiagramModel;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeDiagramPart;
import oracle.eclipse.tools.common.ui.diagram.parts.NodePartFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class DependencyEditor
extends NodeDiagramEditor {
    private ISelectionListener _selectionListener;
    private DependencyFilter _dependencyFilter;
    private IArtifact _artifact;
    private ArtifactController _controller;
    private IDependencyModelListener _dependencyModelListener;

    public void dispose() {
        if (this._selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this._selectionListener);
            this._selectionListener = null;
        }
        if (this._dependencyModelListener != null) {
            this._controller.removeListener(this._dependencyModelListener);
            this._dependencyModelListener = null;
        }
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this._selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                DependencyEditor.this.partSelectionChanged(part, selection);
            }
        };
        site.getWorkbenchWindow().getSelectionService().addSelectionListener(this._selectionListener);
    }

    private void partSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor()) && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object first = ss.getFirstElement();
            if (first instanceof IResource) {
                ResourceArtifact artifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)first);
                this.refreshNewArtifact((IArtifact)artifact);
            } else if (first instanceof IArtifact) {
                this.refreshNewArtifact((IArtifact)first);
            }
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this._controller = ArtifactControllerFactory.getController();
        if (input instanceof DependencyEditorInput) {
            this._artifact = ((DependencyEditorInput)input).getArtifact();
        } else if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            this._artifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)file);
        }
        DependencyEditorModel model = new DependencyEditorModel(this._controller, this._artifact, this.getDependencyFilter(), true);
        this.setModel(model);
        this._dependencyModelListener = new IDependencyModelListener(){

            public void modelChanged(DependencyModelEvent event) {
                switch (event.getType()) {
                    case UPDATED: 
                    case REFRESHED: {
                        DependencyEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DependencyEditor.this.refreshModel(true);
                            }
                        });
                    }
                }
            }

            public void projectClosed(IProject project) {
                DependencyEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DependencyEditor.this.refreshModel(false);
                    }
                });
            }
        };
        this._controller.addListener(this._dependencyModelListener);
    }

    public NodePartFactory getNodePartFactory() {
        return new ArtifactNodePartFactory(this);
    }

    public NodeDiagramToolbarPane createToolbarPane(Composite parent) {
        return new DependencyToolbarPane(parent);
    }

    public MenuManager getContextMenuManager() {
        return new DependencyContextMenuProvider(this);
    }

    public void populateCanvasContextMenu(IMenuManager menuMgr) {
        this.addZoomSubMenu(menuMgr);
        menuMgr.add((IContributionItem)new Separator());
        NodeDiagramPart modelPart = this.getModelEditPart();
        NodeDiagramModel model = (NodeDiagramModel)modelPart.getModel();
        String defaultImageName = this.getDefaultImageName(model.getModelName());
        GraphEditorExportToImageAction egvAction = new GraphEditorExportToImageAction(this.getGraphicalViewer(), modelPart.getFigure(), null, defaultImageName);
        menuMgr.add((IAction)egvAction);
        menuMgr.add((IAction)new GraphicalEditorPrintAction((IWorkbenchPart)this));
    }

    public void refreshNewArtifact(IArtifact artifact) {
        this._artifact = artifact;
        this.refreshModel(false);
    }

    public void refreshNewFilter(DependencyFilter filter) {
        this._dependencyFilter = filter;
        this.refreshModel(true);
    }

    private void refreshModel(boolean recreate) {
        this._artifact = this.ensureArtifact(this._artifact);
        if (this._artifact != null) {
            DependencyEditorModel localModel = (DependencyEditorModel)this.getModel();
            DependencyFilter filter = this.getDependencyFilter();
            if (localModel == null || localModel.getArtifact() != this._artifact || recreate) {
                DependencyEditorModel model = new DependencyEditorModel(this._controller, this._artifact, filter, false);
                this.setModel(model);
                this.getGraphicalViewer().setContents((Object)model);
            }
            this.selectObject(this._artifact);
        }
    }

    private IArtifact ensureArtifact(IArtifact artifact) {
        IArtifact ensuredArtifact = null;
        if (artifact != null) {
            IArtifact newArtifact = DependencyModelManager.getInstance().getModel().queryArtifactsByOwnerNameAndType(artifact.getOwner(), artifact.getName(), artifact.getType());
            ensuredArtifact = newArtifact != null ? newArtifact : this.ensureArtifact(artifact.getOwner());
        }
        return ensuredArtifact;
    }

    public DependencyFilter getDependencyFilter() {
        if (this._dependencyFilter == null) {
            this._dependencyFilter = new DependencyFilter();
        }
        return this._dependencyFilter;
    }

    public void refresh() {
        this.refreshModel(false);
    }
}

