/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.dependency;

import java.util.Map;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.ui.dependency.artifact.internal.ArtifactActionProviderExtensionReader;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class ArtifactActionProvider
extends CommonActionProvider {
    private OpenAction openAction;
    private DeleteAction deleteAction;
    private final Map<String, IActionDelegate> openActionDelegates = ArtifactActionProviderExtensionReader.getOpenActionDelegates();
    private final Map<String, IActionDelegate> deleteActionDelegates = ArtifactActionProviderExtensionReader.getDeleteActionDelegates();

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer viewer;
        super.init(aSite);
        this.openAction = new OpenAction();
        this.deleteAction = new DeleteAction();
        if (aSite != null && (viewer = aSite.getStructuredViewer()) != null) {
            ISelection selection = viewer.getSelection();
            if (selection != null) {
                this.openAction.setSelection(selection);
                this.deleteAction.setSelection(selection);
            }
            viewer.addSelectionChangedListener((ISelectionChangedListener)this.openAction);
            viewer.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
    }

    public IActionDelegate getOpenActionDelegate(String typeID) {
        IActionDelegate actionDelegate = null;
        if (typeID != null) {
            actionDelegate = this.openActionDelegates.get(typeID);
        }
        return actionDelegate;
    }

    public IActionDelegate getDeleteActionDelegate(String typeID) {
        IActionDelegate actionDelegate = null;
        if (typeID != null) {
            actionDelegate = this.deleteActionDelegates.get(typeID);
        }
        return actionDelegate;
    }

    class CommonAction
    extends Action
    implements ISelectionChangedListener {
        protected ISelection selection;

        CommonAction() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.selection = event != null ? event.getSelection() : null;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        protected IArtifact getArtifact() {
            Object objArtifact;
            IArtifact artifact = null;
            if (this.selection instanceof ITreeSelection && (objArtifact = ((ITreeSelection)this.selection).getFirstElement()) instanceof IArtifact) {
                artifact = (IArtifact)objArtifact;
            }
            return artifact;
        }

        protected String getArtifactTypeID() {
            String typeID = null;
            IArtifact artifact = this.getArtifact();
            if (artifact != null) {
                typeID = artifact.getType();
            }
            return typeID;
        }

        protected void runOpenActionDelegate() {
            IActionDelegate actionDelegate;
            String typeID;
            if (this.selection != null && (typeID = this.getArtifactTypeID()) != null && (actionDelegate = ArtifactActionProvider.this.getOpenActionDelegate(typeID)) != null) {
                actionDelegate.selectionChanged(null, this.selection);
                actionDelegate.run(null);
            }
        }

        protected void runDeleteActionDelegate() {
            IActionDelegate actionDelegate;
            String typeID;
            if (this.selection != null && (typeID = this.getArtifactTypeID()) != null && (actionDelegate = ArtifactActionProvider.this.getDeleteActionDelegate(typeID)) != null) {
                actionDelegate.selectionChanged(null, this.selection);
                actionDelegate.run(null);
            }
        }
    }

    class DeleteAction
    extends CommonAction {
        DeleteAction() {
        }

        public void run() {
            this.runDeleteActionDelegate();
        }
    }

    class OpenAction
    extends CommonAction {
        OpenAction() {
        }

        public void run() {
            this.runOpenActionDelegate();
        }
    }
}

