/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.appgen.compare;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.services.appgen.compare.DiffChangeElement;
import oracle.eclipse.tools.common.services.appgen.compare.IDiffChange;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.ui.appgen.compare.CompareInput;
import org.eclipse.compare.internal.merge.DocumentMerger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class DefaultDocumentCompare {
    public static final int NOCHANGE = 0;
    public static final int CHANGE = 2;
    public static final int CONFLICT = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int ANCESTOR = 4;
    public static final int ERROR = 5;

    public static List<IDiffChange> createDiffChanges(CompareInput input, Comparator<String> ... comparators) throws GenerationException {
        ArrayList<IDiffChange> changeList = new ArrayList<IDiffChange>();
        DocumentMerger docMerger = new DocumentMerger((DocumentMerger.IDocumentMergerInput)input);
        try {
            docMerger.doDiff();
            if (docMerger.hasChanges()) {
                Iterator iterator = docMerger.changesIterator();
                while (iterator.hasNext()) {
                    DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                    IDiffChange diffChange = DefaultDocumentCompare.createDiffChangeElement(input, diff);
                    if (comparators.length != 0 && !DefaultDocumentCompare.isChange(input, diffChange, comparators)) continue;
                    changeList.add(DefaultDocumentCompare.createDiffChangeElement(input, diff));
                }
            }
        }
        catch (CoreException e) {
            throw new GenerationException((Throwable)e);
        }
        catch (BadLocationException e) {
            throw new GenerationException((Throwable)e);
        }
        return changeList;
    }

    private static boolean isChange(CompareInput input, IDiffChange diffChange, Comparator<String> ... comparators) throws BadLocationException {
        String changeContent = diffChange.getChangeContent();
        IDocument source = input.getDocument('L');
        Position pos = diffChange.getSourcePosition();
        String sourceContent = source.get(pos.getOffset(), pos.getLength());
        Comparator<String>[] comparatorArray = comparators;
        int n = comparators.length;
        int n2 = 0;
        while (n2 < n) {
            Comparator<String> comparator = comparatorArray[n2];
            if (comparator.compare(sourceContent, changeContent) != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IDiffChange createDiffChangeElement(CompareInput input, DocumentMerger.Diff diff) throws BadLocationException {
        Position lPos = diff.getPosition('L');
        Position rPos = diff.getPosition('R');
        IDocument rDoc = input.getDocument('R');
        String rText = rDoc.get(rPos.getOffset(), rPos.getLength());
        IDiffChange.ChangeType cType = null;
        if (diff.getKind() == 2 && lPos.getLength() > 0 && rPos.getLength() > 0) {
            cType = IDiffChange.ChangeType.REPLACE;
        } else if (diff.getKind() == 2 && lPos.getLength() == 0) {
            cType = IDiffChange.ChangeType.ADDITION;
        } else if (diff.getKind() == 2 && lPos.getLength() > 0 && rPos.getLength() == 0) {
            cType = IDiffChange.ChangeType.DELETE;
        } else if (diff.getKind() != 1) {
            diff.getKind();
        }
        return new DiffChangeElement(lPos, rPos, rText, cType);
    }
}

