/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.appgen.compare;

import oracle.eclipse.tools.common.services.ui.appgen.compare.CompareContainer;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.contentmergeviewer.TokenComparator;
import org.eclipse.compare.internal.merge.DocumentMerger;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;

public class CompareInput
implements DocumentMerger.IDocumentMergerInput {
    public static final char ANCESTOR_CONTRIBUTOR = 'A';
    public static final char RIGHT_CONTRIBUTOR = 'R';
    public static final char LEFT_CONTRIBUTOR = 'L';
    private final IDocument sourceDocument;
    private final IDocument mergeDocument;
    private final IDocument ancestorDocument;
    private final CompareConfiguration compareConfiguration;

    public CompareInput(IDocument sourceDocument, IDocument mergeDocument, IDocument ancestorDocument) {
        this.sourceDocument = sourceDocument;
        this.mergeDocument = mergeDocument;
        this.ancestorDocument = ancestorDocument;
        this.compareConfiguration = new CompareConfiguration();
        this.compareConfiguration.setProperty("IGNORE_WHITESPACE", (Object)new Boolean(true));
        this.compareConfiguration.setContainer((ICompareContainer)new CompareContainer());
    }

    public IDocument getDocument(char contributor) {
        switch (contributor) {
            case 'L': {
                return this.sourceDocument;
            }
            case 'R': {
                return this.mergeDocument;
            }
            case 'A': {
                return this.ancestorDocument;
            }
        }
        return null;
    }

    public Position getRegion(char contributor) {
        switch (contributor) {
            case 'L': {
                return new Position(0, this.sourceDocument.getLength());
            }
            case 'R': {
                return new Position(0, this.mergeDocument.getLength());
            }
            case 'A': {
                return new Position(0, this.ancestorDocument.getLength());
            }
        }
        return null;
    }

    public Region getRegionAsRegion(char contributor) {
        Position pos = this.getRegion(contributor);
        return new Region(pos.getOffset(), pos.getLength());
    }

    public boolean isIgnoreAncestor() {
        return true;
    }

    public boolean isThreeWay() {
        return false;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.compareConfiguration;
    }

    public ITokenComparator createTokenComparator(String s) {
        return new TokenComparator(s);
    }

    public boolean isHunkOnLeft() {
        return false;
    }

    public int getHunkStart() {
        return 0;
    }

    public boolean isPatchHunk() {
        return false;
    }

    public boolean isShowPseudoConflicts() {
        return false;
    }

    public boolean isPatchHunkOk() {
        return false;
    }
}

