/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.ui.appgen.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.common.services.appgen.compare.IChangeCompareFactory;
import oracle.eclipse.tools.common.services.appgen.compare.IDiffChange;
import oracle.eclipse.tools.common.services.appgen.compare.WhitespaceCompare;
import oracle.eclipse.tools.common.services.appgen.compare.XMLCompareComposite;
import oracle.eclipse.tools.common.services.appgen.generators.GenerationException;
import oracle.eclipse.tools.common.services.ui.appgen.Messages;
import oracle.eclipse.tools.common.services.ui.appgen.compare.CompareInput;
import oracle.eclipse.tools.common.services.ui.appgen.compare.DefaultDocumentCompare;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class ChangeCompareFactory
implements IChangeCompareFactory {
    private static final StructuredModelXMLDocumentProvider sseXMLDocProvider = new StructuredModelXMLDocumentProvider(StructuredModelXMLDocumentProvider.ModelRequestType.SHARED_READ);

    public List<IDiffChange> createCompareChanges(IFile file, String compareContents) throws GenerationException {
        CompareInput compareInput;
        DocumentType type;
        IDocument compareDocument;
        IDocument sourceDocument;
        block3: {
            List<IDiffChange> list;
            sourceDocument = null;
            compareDocument = null;
            type = null;
            try {
                type = ChangeCompareFactory.getDocumentType(file);
                sourceDocument = ChangeCompareFactory.getDocument(type, file);
                compareDocument = ChangeCompareFactory.getDocument(type, file.getName(), compareContents);
                ChangeCompareFactory.setupDocument(type, sourceDocument);
                ChangeCompareFactory.setupDocument(type, compareDocument);
                compareInput = new CompareInput(sourceDocument, compareDocument, null);
                if (!DocumentType.XML.equals((Object)type)) break block3;
                list = DefaultDocumentCompare.createDiffChanges(compareInput, new Comparator[]{new XMLCompareComposite()});
            }
            catch (Throwable throwable) {
                ChangeCompareFactory.teardownDocument(type, sourceDocument);
                ChangeCompareFactory.teardownDocument(type, compareDocument);
                throw throwable;
            }
            ChangeCompareFactory.teardownDocument(type, sourceDocument);
            ChangeCompareFactory.teardownDocument(type, compareDocument);
            return list;
        }
        List<IDiffChange> list = DefaultDocumentCompare.createDiffChanges(compareInput, new Comparator[]{new WhitespaceCompare()});
        ChangeCompareFactory.teardownDocument(type, sourceDocument);
        ChangeCompareFactory.teardownDocument(type, compareDocument);
        return list;
    }

    public static List<IDiffChange> createCompareChanges(IFile file, String baseText, String compareText) throws GenerationException {
        CompareInput compareInput;
        DocumentType type;
        IDocument compareDocument;
        IDocument sourceDocument;
        block3: {
            List<IDiffChange> list;
            sourceDocument = null;
            compareDocument = null;
            type = null;
            try {
                type = ChangeCompareFactory.getDocumentType(file);
                sourceDocument = ChangeCompareFactory.getDocument(type, file.getName(), baseText);
                compareDocument = ChangeCompareFactory.getDocument(type, file.getName(), compareText);
                ChangeCompareFactory.setupDocument(type, sourceDocument);
                ChangeCompareFactory.setupDocument(type, compareDocument);
                compareInput = new CompareInput(sourceDocument, compareDocument, null);
                if (!DocumentType.XML.equals((Object)type)) break block3;
                list = DefaultDocumentCompare.createDiffChanges(compareInput, new Comparator[]{new XMLCompareComposite()});
            }
            catch (Throwable throwable) {
                ChangeCompareFactory.teardownDocument(type, sourceDocument);
                ChangeCompareFactory.teardownDocument(type, compareDocument);
                throw throwable;
            }
            ChangeCompareFactory.teardownDocument(type, sourceDocument);
            ChangeCompareFactory.teardownDocument(type, compareDocument);
            return list;
        }
        List<IDiffChange> list = DefaultDocumentCompare.createDiffChanges(compareInput, new Comparator[]{new WhitespaceCompare()});
        ChangeCompareFactory.teardownDocument(type, sourceDocument);
        ChangeCompareFactory.teardownDocument(type, compareDocument);
        return list;
    }

    protected static IDocument getDocument(DocumentType type, IFile file) throws GenerationException {
        if (DocumentType.JAVA.equals((Object)type) || DocumentType.PROPERTIES.equals((Object)type)) {
            try {
                return new Document(ChangeCompareFactory.readFile(file));
            }
            catch (IOException e) {
                String message = Messages.bind((String)Messages.CompareContent_failedToReadFile, (Object)file.getName(), (Object)e.getLocalizedMessage());
                throw new GenerationException(message, (Throwable)e);
            }
            catch (CoreException e) {
                String message = Messages.bind((String)Messages.CompareContent_failedToReadFile, (Object)file.getName(), (Object)e.getLocalizedMessage());
                throw new GenerationException(message, (Throwable)e);
            }
        }
        try {
            org.w3c.dom.Document document = sseXMLDocProvider.getXMLDocument(file);
            if (document instanceof IDOMDocument) {
                IStructuredDocument iStructuredDocument = ((IDOMDocument)document).getStructuredDocument();
                return iStructuredDocument;
            }
            return null;
        }
        finally {
            sseXMLDocProvider.release();
        }
    }

    protected static IDocument getDocument(DocumentType type, String filename, String source) throws GenerationException {
        if (DocumentType.JAVA.equals((Object)type) || DocumentType.PROPERTIES.equals((Object)type)) {
            return new Document(source);
        }
        IModelManager manager = StructuredModelManager.getModelManager();
        try {
            return manager.createStructuredDocumentFor(filename, source, null);
        }
        catch (IOException e) {
            throw new GenerationException((Throwable)e);
        }
    }

    protected static void setupDocument(DocumentType type, IDocument document) {
        String partitioning = ChangeCompareFactory.getDocumentPartitioning(type);
        if (partitioning == null || !(document instanceof IDocumentExtension3)) {
            IDocumentPartitioner partitioner;
            if (document.getDocumentPartitioner() == null && (partitioner = ChangeCompareFactory.getDocumentPartitioner(type)) != null) {
                document.setDocumentPartitioner(partitioner);
                partitioner.connect(document);
            }
        } else {
            IDocumentPartitioner partitioner;
            IDocumentExtension3 ex3 = (IDocumentExtension3)document;
            if (ex3.getDocumentPartitioner(partitioning) == null && (partitioner = ChangeCompareFactory.getDocumentPartitioner(type)) != null) {
                ex3.setDocumentPartitioner(partitioning, partitioner);
                partitioner.connect(document);
            }
        }
    }

    protected static void teardownDocument(DocumentType type, IDocument document) {
        if (document != null) {
            String partitioning = ChangeCompareFactory.getDocumentPartitioning(type);
            if (partitioning == null || !(document instanceof IDocumentExtension3)) {
                IDocumentPartitioner partitioner;
                if (document.getDocumentPartitioner() == null && (partitioner = ChangeCompareFactory.getDocumentPartitioner(type)) != null) {
                    document.setDocumentPartitioner(null);
                    partitioner.disconnect();
                }
            } else {
                IDocumentPartitioner partitioner;
                IDocumentExtension3 ex3 = (IDocumentExtension3)document;
                if (ex3.getDocumentPartitioner(partitioning) == null && (partitioner = ChangeCompareFactory.getDocumentPartitioner(type)) != null) {
                    ex3.setDocumentPartitioner("__dftl_partitioning", null);
                    partitioner.disconnect();
                }
            }
        }
    }

    private static IDocumentPartitioner getDocumentPartitioner(DocumentType type) {
        if (DocumentType.JAVA.equals((Object)type)) {
            return ChangeCompareFactory.createJavaPartitioner();
        }
        return null;
    }

    private static String getDocumentPartitioning(DocumentType type) {
        if (DocumentType.JAVA.equals((Object)type)) {
            return "___java_partitioning";
        }
        return null;
    }

    private static String readFile(IFile file) throws IOException, CoreException {
        InputStreamReader reader = new InputStreamReader(file.getContents(), file.getCharset());
        BufferedReader bufferedReader = new BufferedReader(reader);
        char[] buffer = new char[32768];
        StringBuffer result = new StringBuffer();
        try {
            int count;
            while ((count = bufferedReader.read(buffer)) != -1) {
                result.append(buffer, 0, count);
            }
        }
        finally {
            buffer = null;
            bufferedReader.close();
            reader.close();
        }
        return result.toString();
    }

    private static DocumentType getDocumentType(IFile file) {
        if (file.getFileExtension().endsWith("java")) {
            return DocumentType.JAVA;
        }
        if (file.getFileExtension().endsWith("properties")) {
            return DocumentType.PROPERTIES;
        }
        return DocumentType.XML;
    }

    static JavaTextTools getJavaTextTools() {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin != null) {
            return plugin.getJavaTextTools();
        }
        return null;
    }

    static IDocumentPartitioner createJavaPartitioner() {
        JavaTextTools tools = ChangeCompareFactory.getJavaTextTools();
        if (tools != null) {
            return tools.createDocumentPartitioner();
        }
        return null;
    }

    public static enum DocumentType {
        JAVA,
        PROPERTIES,
        XML;

    }
}

