/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.AbstractArray;
import org.python.core.PyObject;

public class PyObjectArray
extends AbstractArray {
    protected PyObject[] baseArray;

    public void remove(int start, int stop) {
        super.remove(start, stop);
    }

    public PyObjectArray() {
        super(PyObject.class);
    }

    public PyObjectArray(PyObject[] rawArray) {
        super(rawArray == null ? 0 : rawArray.length);
        this.baseArray = rawArray == null ? new PyObject[]{} : rawArray;
    }

    public PyObjectArray(int size) {
        super(PyObject.class, size);
    }

    public PyObjectArray(PyObjectArray toCopy) {
        super(toCopy);
        this.baseArray = (PyObject[])toCopy.copyArray();
    }

    public void add(int index, PyObject value) {
        this.makeInsertSpace(index);
        this.baseArray[index] = value;
    }

    public int add(PyObject value) {
        int index = this.getAddIndex();
        this.baseArray[index] = value;
        return index;
    }

    public Object clone() {
        return new PyObjectArray(this);
    }

    public boolean equals(Object o) {
        if (o instanceof PyObjectArray) {
            PyObjectArray arr = (PyObjectArray)o;
            if (this.size != arr.size) {
                return false;
            }
            int i = 0;
            while (i < this.size) {
                PyObject thisElem = this.baseArray[i];
                PyObject otherElem = arr.baseArray[i];
                if (thisElem == null) {
                    if (otherElem != null) {
                        return false;
                    }
                } else if (!thisElem.equals(otherElem)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int len = this.size;
        int x = 3430008;
        --len;
        while (len >= 0) {
            int y = this.baseArray[len].hashCode();
            x = x + x + x ^ y;
            --len;
        }
        return x ^= this.size;
    }

    protected void discardValues(int from, int to) {
        int i = from;
        while (i < to) {
            this.baseArray[i] = null;
            ++i;
        }
    }

    public PyObject get(int index) {
        if (index >= 0 && index < this.size) {
            return this.baseArray[index];
        }
        String message = this.size == 0 ? "No data was added, unable to get entry at " + index : "Index must be between 0 and " + (this.size - 1) + ", but was " + index;
        throw new ArrayIndexOutOfBoundsException(message);
    }

    public Object getArray() {
        return this.baseArray;
    }

    public PyObject set(int index, PyObject value) {
        if (index >= 0 && index < this.size) {
            PyObject existing = this.baseArray[index];
            this.baseArray[index] = value;
            return existing;
        }
        throw new ArrayIndexOutOfBoundsException("Index must be between 0 and " + (this.size - 1) + ", but was " + index);
    }

    protected void setArray(Object array) {
        this.baseArray = (PyObject[])array;
    }

    public PyObject[] toArray() {
        return (PyObject[])this.copyArray();
    }

    public void ensureCapacity(int minCapacity) {
        super.ensureCapacity(minCapacity);
    }
}

