/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Vector;
import org.python.core.BytecodeLoader1;
import org.python.core.Loader;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyRunnable;
import org.python.core.imp;

public class BytecodeLoader {
    private static Class loaderClass = null;

    static Vector init() {
        Vector<ClassLoader> parents = new Vector<ClassLoader>();
        parents.addElement(imp.getSyspathJavaLoader());
        return parents;
    }

    static Class findParentClass(Vector parents, String name) throws ClassNotFoundException {
        int i = 0;
        while (i < parents.size()) {
            try {
                return ((ClassLoader)parents.elementAt(i)).loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++i;
            }
        }
        throw new ClassNotFoundException(name);
    }

    static void compileClass(Class c) {
        if (!Options.skipCompile) {
            Compiler.compileClass((Class)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Loader makeLoader() {
        if (loaderClass == null) {
            Class<BytecodeLoader> clazz = BytecodeLoader.class;
            // MONITORENTER : org.python.core.BytecodeLoader.class
            String version = System.getProperty("java.version");
            if (version.compareTo("1.2") >= 0) {
                try {
                    loaderClass = Class.forName("org.python.core.BytecodeLoader2");
                }
                catch (Throwable throwable) {
                    loaderClass = BytecodeLoader1.class;
                }
            } else {
                loaderClass = BytecodeLoader1.class;
            }
            // MONITOREXIT : clazz
        }
        try {
            return (Loader)loaderClass.newInstance();
        }
        catch (Exception exception) {
            return new BytecodeLoader1();
        }
    }

    public static Class makeClass(String name, Vector referents, byte[] data) {
        Loader loader = BytecodeLoader.makeLoader();
        if (referents != null) {
            int i = 0;
            while (i < referents.size()) {
                try {
                    Class cls = (Class)referents.elementAt(i);
                    ClassLoader cur = cls.getClassLoader();
                    if (cur != null) {
                        loader.addParent(cur);
                    }
                }
                catch (SecurityException securityException) {}
                ++i;
            }
        }
        return loader.loadClassFromBytes(name, data);
    }

    public static PyCode makeCode(String name, byte[] data, String filename) {
        try {
            Class c = BytecodeLoader.makeClass(name, null, data);
            Object o = c.getConstructor(String.class).newInstance(filename);
            return ((PyRunnable)o).getMain();
        }
        catch (Exception e) {
            throw Py.JavaError(e);
        }
    }
}

