/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.ScopeConstants;
import org.python.compiler.SymInfo;
import org.python.core.Options;
import org.python.parser.SimpleNode;

public class ScopeInfo
implements ScopeConstants {
    public SimpleNode scope_node;
    public String scope_name;
    public int level;
    public int func_level;
    public int list_comprehension_count;
    public int kind;
    public boolean unqual_exec;
    public boolean exec;
    public boolean from_import_star;
    public boolean generator;
    public int yield_count;
    public ArgListCompiler ac;
    public Hashtable tbl = new Hashtable();
    public Vector names = new Vector();
    public int local = 0;
    private static final Object PRESENT = new Object();
    public Hashtable inner_free = new Hashtable();
    public Vector cellvars = new Vector();
    public Vector jy_paramcells = new Vector();
    public int jy_npurecell;
    public int cell;
    public int distance;
    public ScopeInfo up;
    public Vector freevars = new Vector();

    public void dump() {
        if (Options.verbose < 3) {
            return;
        }
        int i = 0;
        while (i < this.level) {
            System.err.print(' ');
            ++i;
        }
        System.err.print(String.valueOf(this.kind != 2 ? this.scope_name : "class " + this.scope_name) + ": ");
        Enumeration e = this.tbl.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            SymInfo info = (SymInfo)this.tbl.get(name);
            int flags = info.flags;
            System.err.print(name);
            if ((flags & 1) != 0) {
                System.err.print('=');
            }
            if ((flags & 2) != 0) {
                System.err.print('G');
            } else if ((flags & 0x40) != 0) {
                System.err.print('g');
            }
            if ((flags & 4) != 0) {
                System.err.print('P');
            } else if ((flags & 8) != 0) {
                System.err.print('p');
            }
            if ((flags & 0x10) != 0) {
                System.err.print('!');
            }
            if ((flags & 0x20) != 0) {
                System.err.print(",f");
            }
            System.err.print(" ");
        }
        System.err.println();
    }

    public ScopeInfo(String name, SimpleNode node, int level, int kind, int func_level, ArgListCompiler ac) {
        this.scope_name = name;
        this.scope_node = node;
        this.level = level;
        this.kind = kind;
        this.func_level = func_level;
        this.ac = ac;
    }

    public int addGlobal(String name) {
        int global = this.kind == 2 ? 64 : 2;
        SymInfo info = (SymInfo)this.tbl.get(name);
        if (info == null) {
            this.tbl.put(name, new SymInfo(global | 1));
            return -1;
        }
        int prev = info.flags;
        info.flags |= global | 1;
        return prev;
    }

    public void addParam(String name) {
        this.tbl.put(name, new SymInfo(5, this.local++));
        this.names.addElement(name);
    }

    public void markFromParam() {
        Enumeration e = this.tbl.elements();
        while (e.hasMoreElements()) {
            SymInfo info = (SymInfo)e.nextElement();
            info.flags |= 8;
        }
    }

    public void addBound(String name) {
        SymInfo info = (SymInfo)this.tbl.get(name);
        if (info == null) {
            this.tbl.put(name, new SymInfo(1));
            return;
        }
        info.flags |= 1;
    }

    public void addUsed(String name) {
        if (this.tbl.get(name) == null) {
            this.tbl.put(name, new SymInfo(0));
            return;
        }
    }

    public void cook(ScopeInfo up, int distance, CompilationContext ctxt) throws Exception {
        if (up == null) {
            return;
        }
        this.up = up;
        this.distance = distance;
        boolean func = this.kind == 1;
        Vector<String> purecells = new Vector<String>();
        this.cell = 0;
        boolean some_inner_free = this.inner_free.size() > 0;
        Enumeration e = this.inner_free.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            SymInfo info = (SymInfo)this.tbl.get(name);
            if (info == null) {
                this.tbl.put(name, new SymInfo(32));
                continue;
            }
            int flags = info.flags;
            if (func) {
                if ((flags & 2) != 0 || (flags & 1) == 0) continue;
                info.flags |= 0x10;
                if ((info.flags & 4) != 0) {
                    this.jy_paramcells.addElement(name);
                }
                this.cellvars.addElement(name);
                ++this.cell;
                info.env_index = info.env_index;
                if ((flags & 4) != 0) continue;
                purecells.addElement(name);
                continue;
            }
            info.flags |= 0x20;
        }
        boolean some_free = false;
        boolean nested = up.kind != 0;
        Enumeration e2 = this.tbl.keys();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            SymInfo info = (SymInfo)this.tbl.get(name);
            int flags = info.flags;
            if (nested && (flags & 0x20) != 0) {
                up.inner_free.put(name, PRESENT);
            }
            if ((flags & 0x56) != 0) continue;
            if ((flags & 1) != 0) {
                this.names.addElement(name);
                ++this.local;
                info.locals_index = info.locals_index;
                continue;
            }
            info.flags |= 0x20;
            some_free = true;
            if (!nested) continue;
            up.inner_free.put(name, PRESENT);
        }
        this.jy_npurecell = purecells.size();
        if (this.jy_npurecell > 0) {
            int sz = purecells.size();
            int i = 0;
            while (i < sz) {
                this.names.addElement(purecells.elementAt(i));
                ++i;
            }
        }
        if (this.unqual_exec || this.from_import_star) {
            if (some_inner_free) {
                this.dynastuff_trouble(true, ctxt);
            } else if (this.func_level > 1 && some_free) {
                this.dynastuff_trouble(false, ctxt);
            }
        }
    }

    private void dynastuff_trouble(boolean inner_free, CompilationContext ctxt) throws Exception {
        String illegal = this.unqual_exec && this.from_import_star ? "function '" + this.scope_name + "' uses import * and bare exec, which are illegal" : (this.unqual_exec ? "unqualified exec is not allowed in function '" + this.scope_name + "'" : "import * is not allowed in function '" + this.scope_name + "'");
        String why = inner_free ? " because it contains a function with free variables" : " because it contains free variables";
        ctxt.error(String.valueOf(illegal) + why, true, this.scope_node);
    }

    public void setup_closure() {
        this.setup_closure(this.up);
    }

    public void setup_closure(ScopeInfo up) {
        int free = this.cell;
        Hashtable up_tbl = up.tbl;
        boolean nested = up.kind != 0;
        Enumeration e = this.tbl.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            SymInfo info = (SymInfo)this.tbl.get(name);
            int flags = info.flags;
            if ((flags & 0x20) == 0) continue;
            SymInfo up_info = (SymInfo)up_tbl.get(name);
            if (up_info != null) {
                int up_flags = up_info.flags;
                if ((up_flags & 0x30) != 0) {
                    info.env_index = free++;
                    this.freevars.addElement(name);
                    continue;
                }
                if (nested && (up_flags & 2) != 0) {
                    info.flags = 3;
                    continue;
                }
            }
            info.flags &= 0xFFFFFFDF;
        }
    }

    public String toString() {
        return "ScopeInfo[" + this.scope_name + " " + this.kind + "]@" + System.identityHashCode(this);
    }
}

