/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import org.python.core.CompilerFlags;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.ast.Expr;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Interactive;
import org.python.parser.ast.Module;
import org.python.parser.ast.Str;
import org.python.parser.ast.modType;
import org.python.parser.ast.stmtType;

public class Future
implements PythonGrammarTreeConstants {
    private boolean division;
    private boolean generators;
    private static final String FUTURE = "__future__";

    private boolean check(ImportFrom cand) throws Exception {
        if (!cand.module.equals(FUTURE)) {
            return false;
        }
        int n = cand.names.length;
        if (n == 0) {
            throw new ParseException("future statement does not support import *", cand);
        }
        int i = 0;
        while (i < n) {
            String feature = cand.names[i].name;
            if (!feature.equals("nested_scopes")) {
                if (feature.equals("division")) {
                    this.division = true;
                } else if (feature.equals("generators")) {
                    this.generators = true;
                } else {
                    throw new ParseException("future feature " + feature + " is not defined", cand);
                }
            }
            ++i;
        }
        return true;
    }

    public void preprocessFutures(modType node, CompilerFlags cflags) throws Exception {
        if (cflags != null) {
            this.division = cflags.division;
        }
        int beg = 0;
        stmtType[] suite = null;
        if (node instanceof Module) {
            suite = ((Module)node).body;
            if (suite.length > 0 && suite[0] instanceof Expr && ((Expr)suite[0]).value instanceof Str) {
                ++beg;
            }
        } else if (node instanceof Interactive) {
            suite = ((Interactive)node).body;
        } else {
            return;
        }
        int i = beg;
        while (i < suite.length) {
            stmtType stmt = suite[i];
            if (!(stmt instanceof ImportFrom)) break;
            stmt.from_future_checked = true;
            if (!this.check((ImportFrom)stmt)) break;
            ++i;
        }
        if (cflags != null) {
            boolean bl = cflags.division = cflags.division || this.division;
        }
        if (cflags != null) {
            cflags.generator_allowed = cflags.generator_allowed || this.generators;
        }
    }

    public static void checkFromFuture(ImportFrom node) throws Exception {
        if (node.from_future_checked) {
            return;
        }
        if (node.module.equals(FUTURE)) {
            throw new ParseException("from __future__ imports must occur at the beginning of the file", node);
        }
        node.from_future_checked = true;
    }

    public boolean areDivisionOn() {
        return this.division;
    }
}

