/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.python.compiler.Bytes;

public class ConstantPool {
    Hashtable constants = new Hashtable();
    int index = 0;
    DataOutputStream tdata;
    ByteArrayOutputStream pool = new ByteArrayOutputStream();
    ByteArrayOutputStream tarray = new ByteArrayOutputStream();
    int[] sizes;

    public ConstantPool() {
        this.tdata = new DataOutputStream(this.tarray);
        this.sizes = new int[256];
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeShort(this.index + 1);
        stream.write(this.pool.toByteArray());
    }

    public int addConstant(int slots) throws IOException {
        Bytes data = new Bytes(this.tarray);
        this.tarray.reset();
        Integer i = (Integer)this.constants.get(data);
        if (i == null) {
            this.pool.write(data.data);
            i = new Integer(this.index);
            this.constants.put(data, i);
            if (this.index + 1 >= this.sizes.length) {
                int[] new_sizes = new int[this.sizes.length * 2];
                System.arraycopy(this.sizes, 0, new_sizes, 0, this.sizes.length);
                this.sizes = new_sizes;
            }
            this.sizes[this.index + 1] = slots;
            this.index += slots;
        }
        return i + 1;
    }

    public int UTF8(String s) throws IOException {
        this.tdata.writeByte(1);
        this.tdata.writeUTF(s);
        return this.addConstant(1);
    }

    public int Class(String s) throws IOException {
        int c = this.UTF8(s);
        this.tdata.writeByte(7);
        this.tdata.writeShort(c);
        return this.addConstant(1);
    }

    public int Fieldref(String c, String name, String type) throws IOException {
        int ic = this.Class(c);
        int nt = this.NameAndType(name, type);
        this.tdata.writeByte(9);
        this.tdata.writeShort(ic);
        this.tdata.writeShort(nt);
        int size = 1;
        if (type.equals("D") || type.equals("J")) {
            size = 2;
        }
        int index = this.addConstant(1);
        this.sizes[index] = size;
        return index;
    }

    public static int sigSize(String sig, boolean includeReturn) {
        int stack = 0;
        int i = 0;
        char[] c = sig.toCharArray();
        int n = c.length;
        boolean ret = false;
        boolean array = false;
        while (++i < n) {
            switch (c[i]) {
                case ')': {
                    if (!includeReturn) {
                        return stack;
                    }
                    ret = true;
                    break;
                }
                case '[': {
                    array = true;
                    break;
                }
                case 'V': {
                    break;
                }
                case 'D': 
                case 'J': {
                    if (array) {
                        stack = ret ? ++stack : --stack;
                        array = false;
                        break;
                    }
                    if (ret) {
                        stack += 2;
                        break;
                    }
                    stack -= 2;
                    break;
                }
                case 'L': {
                    while (c[++i] != ';') {
                    }
                }
                default: {
                    stack = ret ? ++stack : --stack;
                    array = false;
                }
            }
        }
        return stack;
    }

    public int Methodref(String c, String name, String type) throws IOException {
        int ic = this.Class(c);
        int nt = this.NameAndType(name, type);
        this.tdata.writeByte(10);
        this.tdata.writeShort(ic);
        this.tdata.writeShort(nt);
        int index = this.addConstant(1);
        this.sizes[index] = ConstantPool.sigSize(type, true);
        return index;
    }

    public int InterfaceMethodref(String c, String name, String type) throws IOException {
        int ic = this.Class(c);
        int nt = this.NameAndType(name, type);
        this.tdata.writeByte(11);
        this.tdata.writeShort(ic);
        this.tdata.writeShort(nt);
        int index = this.addConstant(1);
        this.sizes[index] = ConstantPool.sigSize(type, true);
        return index;
    }

    public int String(String s) throws IOException {
        int i = this.UTF8(s);
        this.tdata.writeByte(8);
        this.tdata.writeShort(i);
        return this.addConstant(1);
    }

    public int Integer(int i) throws IOException {
        this.tdata.writeByte(3);
        this.tdata.writeInt(i);
        return this.addConstant(1);
    }

    public int Float(float f) throws IOException {
        this.tdata.writeByte(4);
        this.tdata.writeFloat(f);
        return this.addConstant(1);
    }

    public int Long(long l) throws IOException {
        this.tdata.writeByte(5);
        this.tdata.writeLong(l);
        return this.addConstant(2);
    }

    public int Double(double d) throws IOException {
        this.tdata.writeByte(6);
        this.tdata.writeDouble(d);
        return this.addConstant(2);
    }

    public int NameAndType(String name, String type) throws IOException {
        int n = this.UTF8(name);
        int t = this.UTF8(type);
        this.tdata.writeByte(12);
        this.tdata.writeShort(n);
        this.tdata.writeShort(t);
        return this.addConstant(1);
    }

    public static void main(String[] args) throws Exception {
        ConstantPool cp = new ConstantPool();
        System.out.println("c: " + cp.Class("org/python/core/PyString"));
        System.out.println("c: " + cp.Class("org/python/core/PyString"));
        int i = 0;
        while (i < args.length) {
            System.out.println(String.valueOf(args[i]) + ": " + ConstantPool.sigSize(args[i], true));
            ++i;
        }
    }
}

