/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.wsdlc;

import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.ant.WsdlBasedAntTaskArguments;
import oracle.eclipse.tools.webservices.model.jws.JWSJavaPackage;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.util.NameConverter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public final class WsdlcArguments
extends WsdlBasedAntTaskArguments {
    private String serviceName;
    private String portName;
    private IPackageFragmentRoot implDest;
    private IContainer javadocDest;
    private IContainer jwsDest;
    private IFile xmlCatalog;
    private boolean autoDetectWrapped = true;
    private boolean jaxrpcArrayStyle = true;
    private boolean generateJavadoc = false;

    public boolean getGenerateJavadoc() {
        return this.generateJavadoc;
    }

    public void setGenerateJavadoc(boolean generateJavadoc) {
        this.generateJavadoc = generateJavadoc;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public boolean isAutoDetectWrapped() {
        return this.autoDetectWrapped;
    }

    public boolean isJaxRpcArrayStyle() {
        return this.jaxrpcArrayStyle;
    }

    public void setServiceName(String service) {
        this.serviceName = service;
    }

    public void setPortName(String port) {
        this.portName = port;
    }

    public void setAutoDetectWrapped(boolean autoDetectWrapped) {
        this.autoDetectWrapped = autoDetectWrapped;
    }

    public void setJaxRpcArrayStyle(boolean jaxrpcArrayStyle) {
        this.jaxrpcArrayStyle = jaxrpcArrayStyle;
    }

    public String getImplDestinationAsString() {
        return this.implDest.getResource().getProjectRelativePath().toPortableString();
    }

    public IPackageFragmentRoot getImplDestination() {
        return this.implDest;
    }

    public void setImplDestination(IPackageFragmentRoot file) {
        this.implDest = file;
        this.setProject(this.implDest.getResource().getProject());
    }

    public String getJavadocDestinationAsString() {
        return this.javadocDest.getProjectRelativePath().toPortableString();
    }

    public IContainer getJavadocDestination() {
        return this.javadocDest;
    }

    public void setJavadocDestination(IContainer file) {
        this.javadocDest = file;
    }

    public String getJwsDestinationAsString() {
        return this.jwsDest.getProjectRelativePath().toPortableString();
    }

    public IContainer getJwsDestination() {
        return this.jwsDest;
    }

    public void setJwsDestination(IContainer file) {
        this.jwsDest = file;
    }

    public IFile getServiceImplementationIFile() {
        String pkgName = this.getPackageName();
        if (pkgName == null || "".equals(pkgName.trim())) {
            String wsdlUri = this.getWsdlModel().getTargetNamespace();
            pkgName = NameConverter.toPackageName(wsdlUri);
            List<IFile> bindings = this.getBindings();
            if (bindings != null && bindings.size() > 0) {
                for (IFile file : bindings) {
                    String customizedPackage;
                    XmlResourceStore store;
                    try {
                        store = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file));
                    }
                    catch (ResourceStoreException e) {
                        LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
                        break;
                    }
                    JWSModelGroup newGroup = (JWSModelGroup)JWSModelGroup.TYPE.instantiate((Resource)new RootXmlResource(store));
                    JWSJavaPackage javaPackage = (JWSJavaPackage)newGroup.getJavaPackage().content();
                    if (javaPackage == null || (customizedPackage = javaPackage.getName().text()) == null || customizedPackage.equals(pkgName)) continue;
                    pkgName = customizedPackage;
                    break;
                }
            }
        }
        String pkgPath = pkgName.replace('.', '/');
        assert (this.serviceName != null && this.portName != null);
        String name = String.valueOf(this.serviceName) + '_' + this.portName + "Impl." + "java";
        IPath path = new Path(pkgPath).append(name);
        IContainer srcRoot = (IContainer)this.implDest.getResource();
        return srcRoot.getFile(path);
    }

    public IFile getGeneratedJarIFile() {
        IFile wsdlFile = this.getWsdlIFile();
        IPath path = wsdlFile.getProjectRelativePath();
        assert ("wsdl".equals(path.getFileExtension()));
        path = new Path(path.lastSegment().replace('.', '_')).addFileExtension("jar");
        return this.getJwsDestination().getFile(path);
    }

    public String getGeneratedJarAsString() {
        return this.getGeneratedJarIFile().getProjectRelativePath().toPortableString();
    }

    public String getXmlCatalogAsString() {
        return this.xmlCatalog == null ? null : this.xmlCatalog.getProjectRelativePath().toPortableString();
    }

    public void setXmlCatalog(IFile file) {
        this.xmlCatalog = file;
    }

    public IFile getXmlCatalog() {
        return this.xmlCatalog;
    }
}

