/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws.declaration;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.Exclude;
import oracle.eclipse.tools.webservices.validation.jws.annotation.WebMethod;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSDeclaration;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSMethodDeclaration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JWSWebServiceDeclaration
extends JWSDeclaration {
    private final List<JWSMethodDeclaration> webMethods = new ArrayList<JWSMethodDeclaration>();
    private List<IMethod> notOverridedMethods = new ArrayList<IMethod>();

    public JWSWebServiceDeclaration(JWSValidationContext context) {
        super(context);
        this.initMethods();
    }

    public List<JWSMethodDeclaration> getWebMethods() {
        return this.webMethods;
    }

    private void initMethods() {
        for (IMethod method : this.getNonExcludedMethods()) {
            try {
                this.buildMethod(method);
            }
            catch (JavaModelException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
            }
        }
    }

    private void buildMethod(IMethod eiMethod) throws JavaModelException {
        if (this.isWebMethod(eiMethod)) {
            IMethod sbMethod = this.getOverrideMethod(this.getSBType(), eiMethod);
            if (sbMethod == null) {
                this.notOverridedMethods.add(eiMethod);
            } else {
                JWSMethodDeclaration webMethodDecl = new JWSMethodDeclaration(this.context, this, eiMethod, sbMethod);
                this.webMethods.add(webMethodDecl);
            }
        }
    }

    private List<IMethod> getNonExcludedMethods() {
        ArrayList<IMethod> nonExcludedMethods = new ArrayList<IMethod>();
        Object typeDeclaration = this.getEIType();
        if (typeDeclaration != null) {
            ITypeHierarchy typeHierarchy = null;
            try {
                typeHierarchy = typeDeclaration.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
            }
            while (typeDeclaration != null) {
                IMethod[] methods;
                Exclude exclude = new Exclude((IType)typeDeclaration, (IAnnotatable)typeDeclaration, this.context);
                if (exclude.exists()) break;
                try {
                    methods = typeDeclaration.getMethods();
                }
                catch (JavaModelException javaModelException) {
                    break;
                }
                int i = 0;
                while (i < methods.length) {
                    try {
                        if (!methods[i].isConstructor() && !(exclude = new Exclude((IType)typeDeclaration, (IAnnotatable)methods[i], this.context)).getExclude()) {
                            nonExcludedMethods.add(methods[i]);
                        }
                    }
                    catch (JavaModelException e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
                    }
                    ++i;
                }
                typeDeclaration = typeHierarchy != null ? typeHierarchy.getSuperclass(typeDeclaration) : null;
            }
        }
        return nonExcludedMethods;
    }

    private boolean isWebMethod(IMethod iMethod) throws JavaModelException {
        WebMethod webMethod = new WebMethod(iMethod.getDeclaringType(), (IAnnotatable)iMethod, this.context);
        return webMethod.exists() || Flags.isPublic((int)iMethod.getFlags()) && !this.isObjectMethod(iMethod);
    }

    private boolean isObjectMethod(IMethod eiMethod) {
        IType type = eiMethod.getDeclaringType();
        if (type != null && type.getFullyQualifiedName().equals(Object.class.getName())) {
            return true;
        }
        if ((eiMethod.getElementName().equals("finalize") || eiMethod.getElementName().equals("toString") || eiMethod.getElementName().equals("hashCode") || eiMethod.getElementName().equals("clone")) && (eiMethod.getParameterTypes() == null || eiMethod.getParameterTypes().length == 0)) {
            return true;
        }
        if (eiMethod.getElementName().equals("equals") && eiMethod.getParameterTypes() != null && eiMethod.getParameterTypes().length == 1) {
            String param = eiMethod.getParameterTypes()[0];
            return Signature.toString((String)param).equals(Object.class.getName());
        }
        return false;
    }

    private IMethod getOverrideMethod(IType implClass, IMethod eiMethod) throws JavaModelException {
        IMethod[] methods;
        if (eiMethod.getDeclaringType().equals(implClass)) {
            return eiMethod;
        }
        IMethod[] iMethodArray = methods = implClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String[] eiParams;
            String[] sbParams;
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(eiMethod.getElementName()) && (this.isVoidReturnType(eiMethod) && this.isVoidReturnType(method) || this.isReturnTypeAssignableFrom(method, eiMethod)) && (sbParams = method.getParameterTypes()).length == (eiParams = eiMethod.getParameterTypes()).length) {
                boolean ok = true;
                int i = 0;
                while (ok && i < sbParams.length) {
                    String sbParam = Signature.toString((String)sbParams[i]);
                    String eiParam = Signature.toString((String)eiParams[i]);
                    ok = this.isAssignableFrom(sbParam, eiParam);
                    ++i;
                }
                if (ok) {
                    String[] sbExTypes = method.getExceptionTypes();
                    String[] eiExTypes = eiMethod.getExceptionTypes();
                    int j = 0;
                    while (ok && j < sbExTypes.length) {
                        boolean foundEx = false;
                        int k = 0;
                        while (!foundEx && k < eiExTypes.length) {
                            String fromName = Signature.toString((String)sbExTypes[j]);
                            String toName = Signature.toString((String)eiExTypes[k]);
                            foundEx = this.isAssignableFrom(fromName, toName);
                            ++k;
                        }
                        ok = foundEx;
                        ++j;
                    }
                    if (ok) {
                        return method;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public boolean isSeparateEI() {
        block4: {
            if (StringUtil.isEmpty((String)this.getSBWebServiceAnnotation().getEndpointInterface())) break block4;
            return true;
        }
        try {
            if (this.isEITypeSBTypeEqual() && this.isInterface()) {
                return true;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
        return false;
    }

    public List<IMethod> getNotOverridedMethods() {
        return this.notOverridedMethods;
    }
}

