/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws.declaration;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.declaration.BaseDeclaration;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSParamDeclaration;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSResultDeclaration;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSWebServiceDeclaration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public final class JWSMethodDeclaration
extends BaseDeclaration {
    private JWSWebServiceDeclaration webService;
    private IMethod eiMethod;
    private IMethod sbMethod;
    private JWSResultDeclaration resultType;
    private List<JWSParamDeclaration> webParams = new ArrayList<JWSParamDeclaration>();

    public JWSMethodDeclaration(JWSValidationContext context, JWSWebServiceDeclaration webService, IMethod eiMethod, IMethod sbMethod) {
        super(context);
        this.webService = webService;
        this.eiMethod = eiMethod;
        this.sbMethod = sbMethod;
        this.initParams();
        this.initResult();
    }

    public boolean isVoidWebResult() {
        return this.isVoidReturnType(this.eiMethod);
    }

    public JWSWebServiceDeclaration getWebService() {
        return this.webService;
    }

    public IMethod getEiMethod() {
        return this.eiMethod;
    }

    public IMethod getSbMethod() {
        return this.sbMethod;
    }

    public JWSResultDeclaration getResultType() {
        return this.resultType;
    }

    public List<JWSParamDeclaration> getWebParams() {
        return this.webParams;
    }

    private void initParams() {
        String[] params = this.eiMethod.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            JWSParamDeclaration webParam = new JWSParamDeclaration(this.context, Signature.toString((String)params[i]), i);
            this.webParams.add(webParam);
            ++i;
        }
    }

    private void initResult() {
        try {
            this.resultType = new JWSResultDeclaration(this.context, Signature.toString((String)this.eiMethod.getReturnType()));
        }
        catch (IllegalArgumentException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (Throwable)e);
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
    }
}

