/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws.declaration;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.SoapBinding;
import oracle.eclipse.tools.webservices.validation.jws.annotation.WebService;
import oracle.eclipse.tools.webservices.validation.jws.declaration.BaseDeclaration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JWSDeclaration
extends BaseDeclaration {
    private IType eiType = null;
    private WebService sbWebServiceAnnotation;
    private WebService eiWebServiceAnnotation;
    private SoapBinding eiSoapBinding;
    private SoapBinding sbSoapBinding;
    private String endPointInterface;

    public JWSDeclaration(JWSValidationContext context) {
        super(context);
        this.sbWebServiceAnnotation = new WebService(context);
        this.sbSoapBinding = new SoapBinding(context);
        this.initTypes();
    }

    private void initTypes() {
        this.endPointInterface = this.sbWebServiceAnnotation.getEndpointInterface();
        if (!StringUtil.isEmpty((String)this.endPointInterface)) {
            IType eiType = ClassUtil.getType((String)this.endPointInterface, (IProject)this.context.getProject());
            if (eiType == null) {
                this.setEIType(this.context.getIcompilationUnit().findPrimaryType());
                this.eiWebServiceAnnotation = this.sbWebServiceAnnotation;
                this.eiSoapBinding = this.sbSoapBinding;
            } else {
                this.setEIType(eiType);
                this.eiWebServiceAnnotation = new WebService(eiType, this.context);
                this.eiSoapBinding = new SoapBinding(eiType, this.context);
            }
        } else {
            this.setEIType(this.context.getIcompilationUnit().findPrimaryType());
            this.eiWebServiceAnnotation = this.sbWebServiceAnnotation;
            this.eiSoapBinding = new SoapBinding(this.context);
        }
    }

    public String getJWSDeclarationName() {
        return String.valueOf(this.getSBType().getPackageFragment().getElementName()) + "." + this.getSBType().getElementName();
    }

    public String getEIDeclarationName() {
        return this.getEIType().getElementName();
    }

    public WebService getSBWebServiceAnnotation() {
        return this.sbWebServiceAnnotation;
    }

    public WebService getEIWebServiceAnnotation() {
        return this.eiWebServiceAnnotation;
    }

    public SoapBinding getEISoapBinding() {
        return this.eiSoapBinding;
    }

    public SoapBinding getSBSoapBinding() {
        return this.sbSoapBinding;
    }

    public TypeDeclaration getSBTypeDeclaration() {
        return this.context.getPrimaryType();
    }

    public IType getSBType() {
        return this.context.getIcompilationUnit().findPrimaryType();
    }

    public void setEIType(IType eiType) {
        this.eiType = eiType;
    }

    public IType getEIType() {
        if (this.eiType == null) {
            return this.context.getIcompilationUnit().findPrimaryType();
        }
        return this.eiType;
    }

    public IAnnotation getEIAnnotation(String annotation) {
        return this.eiType.getAnnotation(annotation);
    }

    public boolean isEITypeSBTypeEqual() {
        IType type = this.getEIType();
        if (type != null) {
            return this.getEIType().equals(this.context.getIcompilationUnit().findPrimaryType());
        }
        return false;
    }

    public boolean isEIInterface() {
        try {
            return Flags.isInterface((int)this.getEIType().getFlags());
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
            return false;
        }
    }

    public boolean isInterface() throws JavaModelException {
        return Flags.isInterface((int)this.getSBType().getFlags());
    }

    public boolean isPublic() throws JavaModelException {
        return Flags.isPublic((int)this.getSBType().getFlags());
    }

    public boolean isAbstract() throws JavaModelException {
        return Flags.isAbstract((int)this.getSBType().getFlags());
    }

    public boolean isFinal() throws JavaModelException {
        return Flags.isFinal((int)this.getSBType().getFlags());
    }

    public boolean hasDefaultConstructor() throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = this.getSBType().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.isConstructor() && Flags.isPublic((int)method.getFlags()) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public MethodDeclaration getDefaultConstructor() {
        final ArrayList constructors = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                if (node.isConstructor()) {
                    constructors.add(node);
                }
                return super.visit(node);
            }
        };
        this.getSBTypeDeclaration().accept(visitor);
        for (MethodDeclaration constructor : constructors) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.parameters() != null && constructor.parameters().size() != 0) continue;
            return constructor;
        }
        return null;
    }

    public boolean hasConstructor() {
        final ArrayList constructors = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                if (node.isConstructor()) {
                    constructors.add(node);
                }
                return super.visit(node);
            }
        };
        this.getSBTypeDeclaration().accept(visitor);
        return constructors.size() > 0;
    }

    public MethodDeclaration getFinalizeMethod() {
        final ArrayList methods = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                if (!node.isConstructor()) {
                    methods.add(node);
                }
                return super.visit(node);
            }
        };
        this.context.getPrimaryType().accept(visitor);
        for (MethodDeclaration method : methods) {
            if (!"finalize".equals(method.getName().getIdentifier()) || method.parameters() != null && method.parameters().size() != 0) continue;
            return method;
        }
        return null;
    }
}

