/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws.declaration;

import java.util.ArrayList;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;

public abstract class BaseDeclaration {
    protected JWSValidationContext context;

    public BaseDeclaration(JWSValidationContext context) {
        this.context = context;
    }

    public boolean isVoidType(Type type) {
        if (type.isPrimitiveType()) {
            return ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID;
        }
        return false;
    }

    public boolean isVoidReturnType(IMethod method) {
        try {
            String signature = method.getReturnType();
            if (this.isPrimitiveReturnType(method) && "V".equals(signature)) {
                return true;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
        return false;
    }

    public boolean isPrimitiveReturnType(IMethod method) {
        try {
            String signature = method.getReturnType();
            int kind = Signature.getTypeSignatureKind((String)signature);
            if (kind == 2) {
                return true;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
        return false;
    }

    public boolean isAssignableFrom(Type fromType, Type toType) {
        ArrayList<String> fromTypes = new ArrayList<String>();
        this.getFullyQualifiedName(fromType, fromTypes);
        ArrayList<String> toTypes = new ArrayList<String>();
        this.getFullyQualifiedName(toType, toTypes);
        if (fromTypes.size() == toTypes.size()) {
            int i = 0;
            while (i < fromTypes.size()) {
                if (!this.isAssignableFrom(fromTypes.get(i), toTypes.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(String fromType, String toType) {
        try {
            if (ClassUtil.isPrimitiveType((String)fromType) || ClassUtil.isPrimitiveType((String)toType)) {
                return fromType.equals(toType);
            }
            toType = ClassUtil.stripArrayDimensions((String)toType);
            toType = ClassUtil.resolveType((String)toType, (ICompilationUnit)this.context.getIcompilationUnit());
            fromType = ClassUtil.stripArrayDimensions((String)fromType);
            fromType = ClassUtil.resolveType((String)fromType, (ICompilationUnit)this.context.getIcompilationUnit());
            if (toType != null && fromType != null && (toType.equals(fromType) || ClassUtil.isAssignableFrom((String)toType, (String)fromType, (IProject)this.context.getProject()))) {
                return true;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isReturnTypeAssignableFrom(IMethod fromMethod, IMethod toMethod) {
        try {
            String toReturn;
            String[] toTypes;
            if (this.isPrimitiveReturnType(fromMethod) || this.isPrimitiveReturnType(toMethod)) {
                return fromMethod.getReturnType().equals(toMethod.getReturnType());
            }
            String fromReturn = fromMethod.getReturnType();
            String[] fromTypes = Signature.getTypeParameters((String)fromReturn);
            if (fromTypes.length == (toTypes = Signature.getTypeParameters((String)(toReturn = toMethod.getReturnType()))).length && fromTypes.length > 0) {
                int i = 0;
                while (i < fromTypes.length) {
                    if (!this.isAssignableFrom(Signature.toString((String)fromTypes[i]), Signature.toString((String)toTypes[i]))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (fromReturn != null && toReturn != null) {
                return this.isAssignableFrom(Signature.toString((String)fromReturn), Signature.toString((String)toReturn));
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
        return false;
    }

    public void getFullyQualifiedName(Type type, ArrayList<String> list) {
        switch (type.getNodeType()) {
            case 5: {
                ArrayType arrayType = (ArrayType)type;
                this.getFullyQualifiedName(arrayType.getElementType(), list);
                break;
            }
            case 74: {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                this.getFullyQualifiedName(parameterizedType.getType(), list);
                for (Type typeArgument : parameterizedType.typeArguments()) {
                    this.getFullyQualifiedName(typeArgument, list);
                }
                break;
            }
            case 39: {
                list.add(((PrimitiveType)type).getPrimitiveTypeCode().toString());
                break;
            }
            case 75: {
                list.add(((QualifiedType)type).getName().getFullyQualifiedName());
                break;
            }
            case 43: {
                list.add(((SimpleType)type).getName().getFullyQualifiedName());
                break;
            }
            case 76: {
                WildcardType wildcardType = (WildcardType)type;
                Type bound = wildcardType.getBound();
                if (bound == null) {
                    return;
                }
                this.getFullyQualifiedName(bound, list);
            }
        }
    }

    public String getQualifiedIdentifier(Name name) {
        String typeName = "";
        while (name.isQualifiedName()) {
            QualifiedName qualifiedName = (QualifiedName)name;
            typeName = "." + qualifiedName.getName().getIdentifier() + typeName;
            name = qualifiedName.getQualifier();
        }
        if (!name.isSimpleName()) {
            return null;
        }
        typeName = String.valueOf(((SimpleName)name).getIdentifier()) + typeName;
        return typeName;
    }
}

