/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws.annotation;

import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.JWSAnnotation;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.BodyDeclaration;

public final class SoapBinding
extends JWSAnnotation {
    public static final String SOAPBINDING_ANNOTATION = "javax.jws.soap.SOAPBinding";
    private String style = "style";
    private String use = "use";
    private String parameterStyle = "parameterStyle";

    public SoapBinding(JWSValidationContext context) {
        super(SOAPBINDING_ANNOTATION, (BodyDeclaration)context.getPrimaryType(), context);
    }

    public SoapBinding(IType primaryType, JWSValidationContext context) {
        super(SOAPBINDING_ANNOTATION, primaryType, (IAnnotatable)primaryType, context);
    }

    public String getStyle() {
        return this.jwsAnnotation.getMemberValue(this.style);
    }

    public String getUse() {
        return this.jwsAnnotation.getMemberValue(this.use);
    }

    public String getParameterStyle() {
        return this.jwsAnnotation.getMemberValue(this.parameterStyle);
    }

    public boolean isDocumentStyle() throws JavaModelException {
        return this.isMatchingAttribute(this.getStyle(), "javax.jws.soap.SOAPBinding.Style.DOCUMENT");
    }

    public boolean isRPCStyle() throws JavaModelException {
        return this.isMatchingAttribute(this.getStyle(), "javax.jws.soap.SOAPBinding.Style.RPC");
    }

    public boolean isLiteral() throws JavaModelException {
        return this.isMatchingAttribute(this.getUse(), "javax.jws.soap.SOAPBinding.Use.LITERAL");
    }

    public boolean isEncoded() throws JavaModelException {
        return this.isMatchingAttribute(this.getUse(), "javax.jws.soap.SOAPBinding.Use.ENCODED");
    }

    public boolean isWrapped() throws JavaModelException {
        return this.isMatchingAttribute(this.getParameterStyle(), "javax.jws.soap.SOAPBinding.ParameterStyle.WRAPPED");
    }

    public boolean isDocLiteralWrapped() throws JavaModelException {
        return this.isDocumentStyle() && this.isLiteral() && this.isWrapped();
    }

    public boolean isDocLiteralBare() throws JavaModelException {
        return this.isDocumentStyle() && this.isLiteral() && !this.isWrapped();
    }
}

