/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws.annotation;

import oracle.eclipse.tools.common.util.ast.JDTUtil;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.IAnnotationContext;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

public final class ASTAnnotationContext
implements IAnnotationContext {
    private IAnnotationBinding annotationBinding;
    private Annotation annotation;
    private JWSValidationContext context;

    public ASTAnnotationContext(String anno, BodyDeclaration declaration, JWSValidationContext context) {
        this.annotationBinding = this.getAnnotationBinding(anno, declaration);
        this.annotation = this.getAnnotation(anno, declaration);
        this.context = context;
    }

    public ASTAnnotationContext(String anno, SingleVariableDeclaration declaration, JWSValidationContext context) {
        this.annotationBinding = this.getAnnotationBinding(anno, declaration);
        this.annotation = this.getAnnotation(anno, declaration);
        this.context = context;
    }

    @Override
    public boolean exists() {
        return this.annotation != null;
    }

    @Override
    public String getMemberValue(String name) {
        if (this.annotation != null) {
            if (this.annotation.isNormalAnnotation()) {
                return ReaderUtil.getExpressionValue((NormalAnnotation)((NormalAnnotation)this.annotation), (String)name);
            }
            if (this.annotation.isSingleMemberAnnotation()) {
                return ReaderUtil.getExpressionValue((Expression)((SingleMemberAnnotation)this.annotation).getValue());
            }
        }
        return null;
    }

    @Override
    public String getBindingMemberValue(String name) {
        if (this.annotationBinding != null) {
            IMemberValuePairBinding[] mvpBindSet;
            IMemberValuePairBinding[] iMemberValuePairBindingArray = mvpBindSet = this.annotationBinding.getAllMemberValuePairs();
            int n = mvpBindSet.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePairBinding mvp = iMemberValuePairBindingArray[n2];
                if (mvp.getName().equals(name) && mvp.getValue() instanceof String) {
                    return (String)mvp.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    private Annotation getAnnotation(String annotationType, BodyDeclaration bodyDeclaration) {
        int dot;
        Annotation node = JDTUtil.getAnnotation((String)annotationType, (BodyDeclaration)bodyDeclaration);
        if (node == null && (dot = annotationType.lastIndexOf(46)) > -1) {
            node = JDTUtil.getAnnotation((String)annotationType.substring(dot), (BodyDeclaration)bodyDeclaration);
        }
        return node;
    }

    private IAnnotationBinding getAnnotationBinding(String annotationType, BodyDeclaration bodyDeclaration) {
        int dot;
        IAnnotationBinding node = JDTUtil.getAnnotationBinding((String)annotationType, (BodyDeclaration)bodyDeclaration);
        if (node == null && (dot = annotationType.lastIndexOf(46)) > -1) {
            node = JDTUtil.getAnnotationBinding((String)annotationType.substring(dot), (BodyDeclaration)bodyDeclaration);
        }
        return node;
    }

    private Annotation getAnnotation(String annotationType, SingleVariableDeclaration declaration) {
        int dot;
        Annotation node = JDTUtil.getAnnotation((String)annotationType, (SingleVariableDeclaration)declaration);
        if (node == null && (dot = annotationType.lastIndexOf(46)) > -1) {
            node = JDTUtil.getAnnotation((String)annotationType.substring(dot), (SingleVariableDeclaration)declaration);
        }
        return node;
    }

    private IAnnotationBinding getAnnotationBinding(String annotationType, SingleVariableDeclaration declaration) {
        int dot;
        IAnnotationBinding node = JDTUtil.getAnnotationBinding((String)annotationType, (SingleVariableDeclaration)declaration);
        if (node == null && (dot = annotationType.lastIndexOf(46)) > -1) {
            node = JDTUtil.getAnnotationBinding((String)annotationType.substring(dot), (SingleVariableDeclaration)declaration);
        }
        return node;
    }

    public int getLinePosition() {
        return this.context.getLinePosition((ASTNode)this.annotation);
    }

    @Override
    public ASTNode getASTNode() {
        return this.annotation;
    }
}

