/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.validation.jws.IWebServiceValidator;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.WebMethodValidator;
import oracle.eclipse.tools.webservices.validation.jws.WebServiceEIValidator;
import oracle.eclipse.tools.webservices.validation.jws.WebServiceProviderValidator;
import oracle.eclipse.tools.webservices.validation.jws.WebServiceSBValidator;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSProviderDeclaration;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSWebServiceDeclaration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;

public class WebServiceValidatorFactory {
    private WebServiceValidatorFactory() {
    }

    public static List<IWebServiceValidator> getValidators(IFile file) {
        ArrayList<IWebServiceValidator> validators = new ArrayList<IWebServiceValidator>();
        JWSValidationContext context = new JWSValidationContext((IResource)file);
        if (WebServiceProject.isWebServiceProvider(file)) {
            JWSProviderDeclaration jwsProviderDeclaration = new JWSProviderDeclaration(context);
            validators.add(new WebServiceProviderValidator(jwsProviderDeclaration, context));
        } else if (WebServiceProject.isWebService(file)) {
            JWSWebServiceDeclaration jwsDeclaration = new JWSWebServiceDeclaration(context);
            if (!jwsDeclaration.isSeparateEI()) {
                validators.add(new WebServiceEIValidator(jwsDeclaration, context));
                validators.add(new WebServiceSBValidator(jwsDeclaration, context));
            } else {
                try {
                    if (!jwsDeclaration.isInterface()) {
                        validators.add(new WebServiceSBValidator(jwsDeclaration, context));
                    } else {
                        validators.add(new WebServiceEIValidator(jwsDeclaration, context));
                    }
                }
                catch (JavaModelException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
                }
            }
            validators.add(new WebMethodValidator(jwsDeclaration, context));
        }
        return validators;
    }
}

