/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws;

import java.util.List;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.ast.JDTUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.validation.jws.ASTVisitorFactory;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.WebServiceBaseValidator;
import oracle.eclipse.tools.webservices.validation.jws.annotation.JDTAnnotationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.SoapBinding;
import oracle.eclipse.tools.webservices.validation.jws.annotation.WebMethod;
import oracle.eclipse.tools.webservices.validation.jws.annotation.WebService;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSMethodDeclaration;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSWebServiceDeclaration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public final class WebServiceSBValidator
extends WebServiceBaseValidator {
    private JWSWebServiceDeclaration jwsDeclaration;
    private static final String[] orphanAnns = new String[]{"weblogic.jws.Policy", "weblogic.jws.Policies"};

    public WebServiceSBValidator(JWSWebServiceDeclaration jwsDeclaration, JWSValidationContext context) {
        super(context);
        this.jwsDeclaration = jwsDeclaration;
    }

    @Override
    public void performValidation() {
        this.checkClassModifiers();
        this.checkMethods();
        this.checkWebServiceAnnotationAgainstEI();
    }

    private void checkWebServiceAnnotationAgainstEI() {
        if (this.jwsDeclaration.isSeparateEI()) {
            SoapBinding soapBinding;
            WebService webService;
            WebService sbWebServiceAnnotation = this.jwsDeclaration.getSBWebServiceAnnotation();
            if (!StringUtil.isEmpty((String)sbWebServiceAnnotation.getName())) {
                this.createMessage(sbWebServiceAnnotation.getASTNode(), Messages.validation_type_sb_EICheck, 2);
            }
            if ((webService = this.jwsDeclaration.getEIWebServiceAnnotation()).exists()) {
                String eiWsdlLocation;
                String sbWsdlLocation = sbWebServiceAnnotation.getWsdlLocation();
                if (!(StringUtil.isEmpty((String)sbWsdlLocation) || StringUtil.isEmpty((String)(eiWsdlLocation = webService.getWsdlLocation())) || eiWsdlLocation.equals(sbWsdlLocation))) {
                    this.createMessage(sbWebServiceAnnotation.getASTNode(), Messages.validation_type_sb_wsdlLocationDeclaredTwice, 2);
                }
            } else {
                this.createMessage(this.jwsDeclaration.getSBWebServiceAnnotation().getASTNode(), Messages.bind((String)Messages.validation_type_sb_EIInvalid, (Object)sbWebServiceAnnotation.getEndpointInterface()), 2);
            }
            if (!this.jwsDeclaration.isEIInterface()) {
                this.createMessage(this.jwsDeclaration.getSBWebServiceAnnotation().getASTNode(), Messages.bind((String)Messages.validation_type_sb_EIInvalid, (Object)sbWebServiceAnnotation.getEndpointInterface()), 2);
            }
            if ((soapBinding = this.jwsDeclaration.getSBSoapBinding()).exists()) {
                this.createMessage(this.jwsDeclaration.getSBSoapBinding().getASTNode(), Messages.bind((String)Messages.validation_type_sb_SoapBinding_notAllowed, (Object)sbWebServiceAnnotation.getEndpointInterface()), 2);
            }
        }
    }

    private void checkMethods() {
        if (this.jwsDeclaration.isSeparateEI()) {
            List<IMethod> methods = this.jwsDeclaration.getNotOverridedMethods();
            for (IMethod method : methods) {
                this.createMessage((ASTNode)this.jwsDeclaration.getSBTypeDeclaration().getName(), Messages.bind((String)Messages.validation_type_ei_MethodNotImplemented, (Object)this.createMethodSignature(method)), 2);
            }
        }
        try {
            IMethod[] allMethods;
            IMethod[] iMethodArray = allMethods = this.jwsDeclaration.getSBType().getMethods();
            int n = allMethods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method;
                method = iMethodArray[n2];
                JWSMethodDeclaration webMethod = this.getWebMethod(method);
                WebMethod tempWebMethod = new WebMethod(this.jwsDeclaration.getSBType(), (IAnnotatable)method, this.context);
                if (webMethod == null && !tempWebMethod.exists()) {
                    String[] stringArray = orphanAnns;
                    int n3 = orphanAnns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String annClass = stringArray[n4];
                        if (JDTAnnotationContext.getIAnnotation(annClass, (IAnnotatable)method) != null) {
                            ASTVisitorFactory.MethodVisitor mv = new ASTVisitorFactory.MethodVisitor(method);
                            this.jwsDeclaration.getSBTypeDeclaration().accept((ASTVisitor)mv);
                            MethodDeclaration methodDeclaration = mv.getMatchNode();
                            this.createMessage((ASTNode)methodDeclaration, Messages.bind((String)Messages.validation_method_noWebMethod, (Object)annClass), 2);
                        }
                        ++n4;
                    }
                }
                if ((webMethod == null || this.jwsDeclaration.isSeparateEI()) && tempWebMethod.exists()) {
                    ASTVisitorFactory.MethodVisitor mv = new ASTVisitorFactory.MethodVisitor(method);
                    this.jwsDeclaration.getSBTypeDeclaration().accept((ASTVisitor)mv);
                    MethodDeclaration methodDeclaration = mv.getMatchNode();
                    this.createMessage((ASTNode)methodDeclaration, Messages.bind((String)Messages.validation_method_WebMethod_notAllowed, (Object)this.createMethodSignature(method)), 2);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
    }

    private void checkClassModifiers() {
        try {
            MethodDeclaration method;
            TypeDeclaration declaration = this.jwsDeclaration.getSBTypeDeclaration();
            if (this.jwsDeclaration.isInterface()) {
                this.createMessage((ASTNode)declaration.getName(), Messages.validation_type_class_SBNotFound, 2, false);
            }
            if (!this.jwsDeclaration.isPublic()) {
                this.createMessage((ASTNode)declaration.getName(), Messages.validation_type_class_isNotPublic, 2);
                if (!this.jwsDeclaration.hasDefaultConstructor()) {
                    this.createMessage((ASTNode)declaration.getName(), Messages.validation_type_class_noDefaultConstructor, 2, false);
                }
            }
            if (this.jwsDeclaration.isAbstract()) {
                this.createMessage((ASTNode)JDTUtil.getModifier((int)1024, (BodyDeclaration)declaration), Messages.validation_type_class_isAbstract, 2);
            }
            if (this.jwsDeclaration.isFinal()) {
                this.createMessage((ASTNode)JDTUtil.getModifier((int)16, (BodyDeclaration)declaration), Messages.validation_type_class_isFinal, 2);
            }
            if (!this.jwsDeclaration.hasDefaultConstructor() && this.jwsDeclaration.hasConstructor()) {
                this.createMessage((ASTNode)declaration.getName(), Messages.validation_type_class_noDefaultConstructor, 2, false);
            }
            if ((method = this.jwsDeclaration.getFinalizeMethod()) != null) {
                this.createMessage((ASTNode)method, Messages.validation_type_class_hasFinalize, 2);
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
    }

    private String createMethodSignature(IMethod method) {
        try {
            String[] exceptionTypes = method.getExceptionTypes();
            StringBuilder builder = new StringBuilder();
            if (Flags.isPublic((int)method.getFlags())) {
                builder.append("public ");
            }
            builder.append(String.valueOf(Signature.toString((String)method.getReturnType())) + " ");
            String signature = Signature.toString((String)method.getSignature().replace('/', '.'), (String)method.getElementName(), null, (boolean)true, (boolean)false, (boolean)false);
            builder.append(signature);
            if (exceptionTypes.length > 0) {
                builder.append(" throws ");
                boolean first = true;
                String[] stringArray = exceptionTypes;
                int n = exceptionTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String exception = stringArray[n2];
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(Signature.toString((String)exception));
                    ++n2;
                }
            }
            return builder.toString();
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
            return method.getElementName();
        }
    }

    private JWSMethodDeclaration getWebMethod(IMethod method) {
        List<JWSMethodDeclaration> webMethods = this.jwsDeclaration.getWebMethods();
        for (JWSMethodDeclaration webMethod : webMethods) {
            if (!webMethod.getSbMethod().equals(method)) continue;
            return webMethod;
        }
        return null;
    }
}

