/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws;

import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.WebServiceBaseValidator;
import oracle.eclipse.tools.webservices.validation.jws.annotation.BindingType;
import oracle.eclipse.tools.webservices.validation.jws.annotation.WebServiceProvider;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSProviderDeclaration;

public final class WebServiceProviderValidator
extends WebServiceBaseValidator {
    private JWSProviderDeclaration jwsProviderDeclaration;

    public WebServiceProviderValidator(JWSProviderDeclaration jwsProviderDeclaration, JWSValidationContext jwsASTContext) {
        super(jwsASTContext);
        this.jwsProviderDeclaration = jwsProviderDeclaration;
    }

    @Override
    public void performValidation() {
        this.checkWsdlLocation();
    }

    private void checkWsdlLocation() {
        BindingType bindingType;
        WebServiceProvider wsProviderAnnotation = this.jwsProviderDeclaration.getProviderAnnotation();
        String wsdlLocation = wsProviderAnnotation.getWsdlLocation();
        if (!(!StringUtil.isEmpty((String)wsdlLocation) || (bindingType = this.jwsProviderDeclaration.getBindingType()).exists() && bindingType.isHttpBinding() || wsProviderAnnotation.getASTNode() == null)) {
            this.createMessage(wsProviderAnnotation.getASTNode(), Messages.bind((String)Messages.validation_type_provider_noWsdlLocation, (Object)this.context.getFullyQualifiedTypeName()), 2);
        }
    }
}

