/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws;

import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.WebServiceBaseValidator;
import oracle.eclipse.tools.webservices.validation.jws.annotation.SoapBinding;
import oracle.eclipse.tools.webservices.validation.jws.annotation.WebService;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSWebServiceDeclaration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;

public class WebServiceEIValidator
extends WebServiceBaseValidator {
    private JWSWebServiceDeclaration jwsDeclaration;

    public WebServiceEIValidator(JWSWebServiceDeclaration jwsDeclaration, JWSValidationContext context) {
        super(context);
        this.jwsDeclaration = jwsDeclaration;
    }

    @Override
    public void performValidation() {
        WebService webService = this.jwsDeclaration.getEIWebServiceAnnotation();
        if (webService.exists()) {
            this.checkClass();
            this.checkTypeAnnotation();
            this.checkSoapBinding();
        } else {
            this.createMessage(this.jwsDeclaration.getSBWebServiceAnnotation().getASTNode(), Messages.bind((String)Messages.validation_type_ei_noWebService, (Object)this.jwsDeclaration.getEIDeclarationName()), 2);
        }
    }

    protected void checkClass() {
        if (this.jwsDeclaration.isSeparateEI() && !this.jwsDeclaration.isEIInterface()) {
            this.createMessage(this.jwsDeclaration.getSBWebServiceAnnotation().getASTNode(), Messages.bind((String)Messages.validation_type_ei_EINotInterface, (Object)this.jwsDeclaration.getEIDeclarationName()), 2);
        }
    }

    protected void checkTypeAnnotation() {
        try {
            if (this.jwsDeclaration.isInterface()) {
                WebService webService = this.jwsDeclaration.getSBWebServiceAnnotation();
                if (!StringUtil.isEmpty((String)webService.getEndpointInterface())) {
                    this.createMessage(webService.getASTNode(), Messages.bind((String)Messages.validation_type_ei_EIDeclaresEI, (Object)this.jwsDeclaration.getJWSDeclarationName()), 2);
                }
                if (!StringUtil.isEmpty((String)webService.getServiceName())) {
                    this.createMessage(webService.getASTNode(), Messages.bind((String)Messages.validation_type_ei_EIDeclaresServiceName, (Object)this.jwsDeclaration.getJWSDeclarationName()), 2);
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
    }

    private void checkSoapBinding() {
        try {
            SoapBinding soapBinding = this.jwsDeclaration.getEISoapBinding();
            if (soapBinding.exists() && soapBinding.isRPCStyle() && soapBinding.isEncoded()) {
                ASTNode node = this.jwsDeclaration.isSeparateEI() && !this.jwsDeclaration.isInterface() ? this.jwsDeclaration.getSBWebServiceAnnotation().getASTNode() : soapBinding.getASTNode();
                this.createMessage(node, Messages.validation_type_ei_jaxws_rpcEncodedNotSupported, 2);
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
    }
}

