/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws;

import java.util.ArrayList;
import oracle.eclipse.tools.webservices.validation.jws.IWebServiceValidator;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidatorMessage;

public abstract class WebServiceBaseValidator
implements IWebServiceValidator {
    protected JWSValidationContext context;
    private ArrayList<ValidatorMessage> validatorMessages = new ArrayList();
    private ArrayList<IResource> dependencies = new ArrayList();

    public WebServiceBaseValidator(JWSValidationContext context) {
        this.context = context;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        this.performValidation();
        for (ValidatorMessage message : this.validatorMessages) {
            result.add(message);
        }
        result.setDependsOn((IResource[])this.dependencies.toArray(new IFile[this.dependencies.size()]));
        return result;
    }

    protected abstract void performValidation();

    protected void createMessage(ASTNode node, String message, int severity) {
        this.createMessage(node, message, severity, true);
    }

    protected void createMessage(ASTNode node, String message, int severity, boolean showRange) {
        ValidatorMessage validatorMessage = ValidatorMessage.create((String)message, (IResource)this.context.getJwsResource());
        validatorMessage.setAttribute("severity", severity);
        if (showRange) {
            validatorMessage.setAttribute("charStart", this.context.getStartPosition(node));
            validatorMessage.setAttribute("charEnd", this.context.getStartPosition(node) + this.context.getLength(node));
        }
        validatorMessage.setAttribute("lineNumber", this.context.getLinePosition(node));
        this.validatorMessages.add(validatorMessage);
    }

    protected void addDependency(IResource resource) {
        this.dependencies.add(resource);
    }
}

