/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.validation.jws.ASTVisitorFactory;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.WebServiceBaseValidator;
import oracle.eclipse.tools.webservices.validation.jws.annotation.Oneway;
import oracle.eclipse.tools.webservices.validation.jws.annotation.WebParam;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSMethodDeclaration;
import oracle.eclipse.tools.webservices.validation.jws.declaration.JWSWebServiceDeclaration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;

public class WebMethodValidator
extends WebServiceBaseValidator {
    private JWSWebServiceDeclaration jwsDeclaration;

    public WebMethodValidator(JWSWebServiceDeclaration jwsDeclaration, JWSValidationContext context) {
        super(context);
        this.jwsDeclaration = jwsDeclaration;
    }

    @Override
    public void performValidation() {
        List<JWSMethodDeclaration> webMethods = this.jwsDeclaration.getWebMethods();
        try {
            for (JWSMethodDeclaration method : webMethods) {
                ASTVisitorFactory.MethodVisitor mv = new ASTVisitorFactory.MethodVisitor(method.getSbMethod());
                this.context.getPrimaryType().accept((ASTVisitor)mv);
                MethodDeclaration methodDeclaration = mv.getMatchNode();
                if (methodDeclaration == null) continue;
                this.checkResult(methodDeclaration);
                this.checkParams(methodDeclaration);
                this.checkPublic(methodDeclaration);
                Oneway oneWay = new Oneway(methodDeclaration, this.context);
                if (!oneWay.exists()) continue;
                this.checkOneWay(methodDeclaration);
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
    }

    protected void checkResult(MethodDeclaration methodDeclaration) throws JavaModelException {
        ArrayList<String> returnTypes = new ArrayList<String>();
        Type returnType = methodDeclaration.getReturnType2();
        if (returnType != null) {
            this.getFullyQualifiedName(methodDeclaration.getReturnType2(), returnTypes);
            for (String fqType : returnTypes) {
                if (!this.isXmlBean(fqType)) continue;
                this.createMessage((ASTNode)returnType, Messages.validation_method_jaxws_xmlBeanNotSupported, 2);
            }
        }
    }

    protected void checkParams(MethodDeclaration methodDeclaration) {
        List parameters = methodDeclaration.parameters();
        if (parameters.size() == 0) {
            return;
        }
        int i = 0;
        while (i < parameters.size()) {
            SingleVariableDeclaration svd = (SingleVariableDeclaration)parameters.get(i);
            ArrayList<String> subParamList = new ArrayList<String>();
            this.getFullyQualifiedName(svd.getType(), subParamList);
            for (String fqParam : subParamList) {
                if (!this.isXmlBean(fqParam)) continue;
                this.createMessage((ASTNode)svd, Messages.validation_method_jaxws_xmlBeanNotSupported, 2);
            }
            ++i;
        }
    }

    protected void checkPublic(MethodDeclaration methodDeclaration) {
        Modifier modifier = this.findMethodAccessModifier(methodDeclaration);
        if (modifier != null && !modifier.isPublic()) {
            this.createMessage((ASTNode)modifier, Messages.bind((String)Messages.validation_method_notPublic, (Object)methodDeclaration.getName().getIdentifier()), 2);
        } else if (modifier == null) {
            this.createMessage((ASTNode)methodDeclaration.getName(), Messages.bind((String)Messages.validation_method_notPublic, (Object)methodDeclaration.getName().getIdentifier()), 2);
        }
    }

    protected void checkOneWay(MethodDeclaration methodDeclaration) {
        List parameters;
        Type returnType = methodDeclaration.getReturnType2();
        if (returnType == null || !returnType.isPrimitiveType() || ((PrimitiveType)returnType).getPrimitiveTypeCode() != PrimitiveType.VOID) {
            this.createMessage((ASTNode)methodDeclaration.getName(), Messages.validation_method_oneway_mustReturnVoid, 2);
        }
        if ((parameters = methodDeclaration.parameters()).size() == 0) {
            return;
        }
        int i = 0;
        while (i < parameters.size()) {
            SingleVariableDeclaration declaration = (SingleVariableDeclaration)parameters.get(i);
            WebParam wParam = new WebParam(declaration, this.context);
            if (wParam.exists() && wParam.getMode() == WebParam.Mode.OUT) {
                this.createMessage((ASTNode)declaration, Messages.validation_method_oneway_noOutputAllowed, 2);
            }
            ++i;
        }
    }

    private boolean isXmlBean(String type) {
        block4: {
            block5: {
                type = ClassUtil.stripArrayDimensions((String)type);
                type = ClassUtil.resolveType((String)type, (ICompilationUnit)this.context.getIcompilationUnit());
                if (type == null) break block4;
                if (!ClassUtil.isAssignableFrom((String)type, (String)"org.apache.xmlbeans.XmlObject", (IProject)this.context.getProject())) break block5;
                return true;
            }
            try {
                if (ClassUtil.isAssignableFrom((String)type, (String)"com.bea.xml.XmlObject", (IProject)this.context.getProject())) {
                    return true;
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
            }
        }
        return false;
    }

    private void getFullyQualifiedName(Type type, ArrayList<String> list) {
        if (type != null) {
            switch (type.getNodeType()) {
                case 5: {
                    ArrayType arrayType = (ArrayType)type;
                    this.getFullyQualifiedName(arrayType.getElementType(), list);
                    break;
                }
                case 74: {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    this.getFullyQualifiedName(parameterizedType.getType(), list);
                    for (Type typeArgument : parameterizedType.typeArguments()) {
                        this.getFullyQualifiedName(typeArgument, list);
                    }
                    break;
                }
                case 39: {
                    list.add(((PrimitiveType)type).getPrimitiveTypeCode().toString());
                    break;
                }
                case 75: {
                    list.add(((QualifiedType)type).getName().getFullyQualifiedName());
                    break;
                }
                case 43: {
                    list.add(((SimpleType)type).getName().getFullyQualifiedName());
                    break;
                }
                case 76: {
                    WildcardType wildcardType = (WildcardType)type;
                    Type bound = wildcardType.getBound();
                    if (bound == null) {
                        return;
                    }
                    this.getFullyQualifiedName(bound, list);
                }
            }
        }
    }

    private Modifier findMethodAccessModifier(MethodDeclaration declaration) {
        List modifiers = declaration.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isModifier()) continue;
            Modifier.ModifierKeyword modifierKeyword = ((Modifier)modifier).getKeyword();
            assert (modifierKeyword != null) : "ModifierKeyword was not resolved. Can this happen in normal operation?";
            switch (modifierKeyword.toFlagValue()) {
                case 2: {
                    return (Modifier)modifier;
                }
                case 4: {
                    return (Modifier)modifier;
                }
                case 1: {
                    return (Modifier)modifier;
                }
            }
        }
        return null;
    }
}

