/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation;

import java.util.HashSet;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.validation.jws.IWebServiceValidator;
import oracle.eclipse.tools.webservices.validation.jws.WebServiceValidatorFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;

public class WebServicesValidator
extends AbstractValidator {
    private static final String MARKER_TYPE = "oracle.eclipse.tools.webservices.validationMarker";

    public ValidationResult validate(ValidationEvent event, ValidationState state, IProgressMonitor monitor) {
        IResource resource = event.getResource();
        if (resource.getType() != 1) {
            return null;
        }
        IFile file = (IFile)resource;
        if (!file.isAccessible()) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        if (!this.hasProjectBuildPathErrors(file.getProject()) && !this.hasBuildErrors(file)) {
            HashSet<ValidatorMessage> dependencies = new HashSet<ValidatorMessage>();
            for (IWebServiceValidator validator : WebServiceValidatorFactory.getValidators(file)) {
                ValidationResult subResult = validator.validate();
                ValidatorMessage[] validatorMessageArray = subResult.getMessages();
                int n = validatorMessageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidatorMessage message = validatorMessageArray[n2];
                    message.setType(MARKER_TYPE);
                    result.add(message);
                    ++n2;
                }
                validatorMessageArray = subResult.getDependsOn();
                n = validatorMessageArray.length;
                n2 = 0;
                while (n2 < n) {
                    ValidatorMessage dependency = validatorMessageArray[n2];
                    dependencies.add(dependency);
                    ++n2;
                }
            }
            result.setDependsOn(dependencies.toArray(new IResource[dependencies.size()]));
        }
        return result;
    }

    private boolean hasBuildErrors(IFile file) {
        try {
            return 2 <= file.findMaxProblemSeverity("org.eclipse.jdt.core.problem", true, 0);
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)e);
            return true;
        }
    }

    private boolean hasProjectBuildPathErrors(IProject project) {
        try {
            return 2 <= project.findMaxProblemSeverity("org.eclipse.jdt.core.buildpath_problem", true, 0);
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)e);
            return true;
        }
    }
}

