/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.util;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceClient;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;

public final class WebServiceResourceListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final WebServiceResourceListener INSTANCE = new WebServiceResourceListener();
    public String DOT_JAR = ".jar";

    private WebServiceResourceListener() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() == 1) {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
            case 1: {
                String name = resource.getName();
                if (!this.endsWithIgnoreCase(name, this.DOT_JAR) || !WebServiceClient.isWebServiceClientsProject(resource.getProject())) break;
                return this.refresh(resource);
            }
        }
        return false;
    }

    private boolean endsWithIgnoreCase(String str, String sfx) {
        return J2EEComponentClasspathUpdater.endsWithIgnoreCase((String)str, (String)sfx);
    }

    private boolean isResourceInWebInfLib(IResource resource) {
        IPath currentResourcePath = resource.getFullPath();
        IFolder dir = new WebServiceProject(resource.getProject()).getInputWebInfLibFolder();
        return dir.getFullPath().isPrefixOf(currentResourcePath);
    }

    public boolean refresh(IResource resource) {
        FlexibleProjectContainer webAppLibrariesContainer;
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)resource.getProject()) && this.isResourceInWebInfLib(resource) && (webAppLibrariesContainer = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer((IProject)resource.getProject())) != null) {
            webAppLibrariesContainer.refresh();
            return true;
        }
        return false;
    }
}

