/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;

public class URIUtil {
    private URIUtil() {
    }

    public static URL getURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException murle) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)murle);
            return null;
        }
    }

    public static IFile getIFile(URI uri) {
        if (uri.isAbsolute() && !uri.getScheme().contains("file")) {
            return null;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        return files == null || files.length < 1 ? null : files[0];
    }

    public static String getRelativePathAsString(URI uri, IResource relativeTo) {
        if (uri == null) {
            return null;
        }
        IFile file = URIUtil.getIFile(uri);
        if (file != null) {
            return EclipseFileUtil.computeRelativeReferencePath((IResource)relativeTo, (IResource)file);
        }
        URL url = URIUtil.getURL(uri);
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }
}

