/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class NameConverter {
    private static HashSet<String> reservedKeywords;

    static {
        String[] words;
        reservedKeywords = new HashSet();
        String[] stringArray = words = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"};
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            reservedKeywords.add(word);
            ++n2;
        }
    }

    public static String toPackageName(String nsUri) {
        ArrayList<String> r;
        String domain;
        String lastToken;
        ArrayList<String> tokens;
        int idx = nsUri.indexOf(58);
        String scheme = "";
        if (idx >= 0 && ((scheme = nsUri.substring(0, idx)).equalsIgnoreCase("http") || scheme.equalsIgnoreCase("urn"))) {
            nsUri = nsUri.substring(idx + 1);
        }
        if ((tokens = NameConverter.tokenize(nsUri, "/: ")).size() == 0) {
            return null;
        }
        if (tokens.size() > 1 && (idx = (lastToken = tokens.get(tokens.size() - 1)).lastIndexOf(46)) > 0) {
            lastToken = lastToken.substring(0, idx);
            tokens.set(tokens.size() - 1, lastToken);
        }
        if ((idx = (domain = tokens.get(0)).indexOf(58)) >= 0) {
            domain = domain.substring(0, idx);
        }
        if ((r = NameConverter.reverse(NameConverter.tokenize(domain, scheme.equals("urn") ? ".-" : "."))).get(r.size() - 1).equalsIgnoreCase("www")) {
            r.remove(r.size() - 1);
        }
        tokens.addAll(1, r);
        tokens.remove(0);
        int i = 0;
        while (i < tokens.size()) {
            String token = tokens.get(i);
            if (!NameConverter.isJavaIdentifier(token = NameConverter.removeIllegalIdentifierChars(token))) {
                token = String.valueOf('_') + token;
            }
            tokens.set(i, token.toLowerCase());
            ++i;
        }
        return NameConverter.combine(tokens, '.');
    }

    private static String removeIllegalIdentifierChars(String token) {
        StringBuffer newToken = new StringBuffer();
        int i = 0;
        while (i < token.length()) {
            char c = token.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c)) {
                newToken.append('_').append(c);
            } else if (!Character.isJavaIdentifierPart(c)) {
                newToken.append('_');
            } else {
                newToken.append(c);
            }
            ++i;
        }
        return newToken.toString();
    }

    private static ArrayList<String> tokenize(String str, String sep) {
        StringTokenizer tokens = new StringTokenizer(str, sep);
        ArrayList<String> r = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            r.add(tokens.nextToken());
        }
        return r;
    }

    private static <T> ArrayList<T> reverse(List<T> a) {
        ArrayList<T> r = new ArrayList<T>();
        int i = a.size() - 1;
        while (i >= 0) {
            r.add(a.get(i));
            --i;
        }
        return r;
    }

    private static String combine(List r, char sep) {
        StringBuilder buf = new StringBuilder(r.get(0).toString());
        int i = 1;
        while (i < r.size()) {
            buf.append(sep);
            buf.append(r.get(i));
            ++i;
        }
        return buf.toString();
    }

    public static boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (reservedKeywords.contains(s)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

