/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class JarFileHandler {
    private final IProject project;
    private final File jarWorkingDir;
    private final File jarFile;

    public JarFileHandler(String jarFileName, IProject project) {
        this(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(jarFileName)), project);
    }

    public JarFileHandler(IFile jarIFile, IProject project) {
        this.project = project;
        File projectWorkingDir = WebServicesCorePlugin.getDefault().getStateLocation().toFile();
        this.jarWorkingDir = new File(projectWorkingDir, jarIFile.getName());
        URI uri = jarIFile.getLocationURI();
        if (uri == null) {
            throw new NullPointerException("Unable to determine jar file location from: " + jarIFile);
        }
        this.jarFile = new File(uri);
    }

    public JarFileHandler(File jarFile, IProject project) {
        this.project = project;
        this.jarFile = jarFile;
        File projectWorkingDir = WebServicesCorePlugin.getDefault().getStateLocation().toFile();
        this.jarWorkingDir = new File(projectWorkingDir, jarFile.getName());
    }

    public void expandJar(IProgressMonitor monitor) throws IOException {
        ZipUtil.unzip((File)this.jarFile, (File)this.jarWorkingDir, (IProgressMonitor)monitor);
    }

    public static void closeJarFile(ZipFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException iOException) {}
    }

    protected static InputStream getCachedInputStream(String jarFilename, String entryName) {
        ByteArrayInputStream cache;
        block20: {
            File testFile = new File(jarFilename);
            if (!testFile.exists()) {
                return JarFileHandler.getInputStream((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(jarFilename)), entryName);
            }
            cache = null;
            ZipFile jarfile = null;
            try {
                jarfile = new ZipFile(jarFilename);
            }
            catch (IOException iOException) {
                JarFileHandler.closeJarFile(jarfile);
            }
            if (jarfile != null) {
                try {
                    ZipEntry zentry = jarfile.getEntry(entryName);
                    if (zentry == null) break block20;
                    InputStream entryInputStream = null;
                    try {
                        entryInputStream = jarfile.getInputStream(zentry);
                    }
                    catch (IOException iOException) {}
                    if (entryInputStream == null) break block20;
                    ByteArrayOutputStream buffer = null;
                    buffer = zentry.getSize() > 0L ? new ByteArrayOutputStream((int)zentry.getSize()) : new ByteArrayOutputStream();
                    byte[] bytes = new byte[2048];
                    try {
                        try {
                            int c;
                            while ((c = entryInputStream.read(bytes)) >= 0) {
                                buffer.write(bytes, 0, c);
                            }
                            cache = new ByteArrayInputStream(buffer.toByteArray());
                            JarFileHandler.closeJarFile(jarfile);
                        }
                        catch (IOException iOException) {
                            try {
                                entryInputStream.close();
                            }
                            catch (IOException iOException2) {}
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            entryInputStream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        entryInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    JarFileHandler.closeJarFile(jarfile);
                }
            }
        }
        return cache;
    }

    private static InputStream copyAndCloseStream(InputStream original) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteArrayInputStream cachedCopy = null;
        if (original != null) {
            byte[] bytes = new byte[2048];
            try {
                int c;
                while ((c = original.read(bytes)) >= 0) {
                    buffer.write(bytes, 0, c);
                }
                cachedCopy = new ByteArrayInputStream(buffer.toByteArray());
                JarFileHandler.closeStream(original);
            }
            catch (IOException iOException) {}
        }
        return cachedCopy;
    }

    public static String[] getEntryNames(IResource jarResource) {
        if (jarResource == null || jarResource.getType() != 1 || !jarResource.isAccessible()) {
            return new String[0];
        }
        try {
            return JarFileHandler.getEntryNames(jarResource.getFullPath().toString(), new ZipInputStream(((IFile)jarResource).getContents()), true);
        }
        catch (CoreException coreException) {
            IPath location = jarResource.getLocation();
            if (location != null) {
                return JarFileHandler.getEntryNames(location.toString());
            }
            return new String[0];
        }
    }

    public static String[] getEntryNames(String jarFilename) {
        return JarFileHandler.getEntryNames(jarFilename, true);
    }

    private static String[] getEntryNames(String filename, ZipInputStream jarInputStream, boolean excludeDirectories) {
        ArrayList<String> entryNames;
        block9: {
            entryNames = new ArrayList<String>();
            try {
                ZipEntry z = jarInputStream.getNextEntry();
                while (z != null) {
                    if (!z.isDirectory() || !excludeDirectories) {
                        entryNames.add(z.getName());
                    }
                    z = jarInputStream.getNextEntry();
                }
            }
            catch (ZipException zExc) {
                LoggingService.logException((String)"oracle.eclipse.tools.webservices", (Throwable)zExc, (String)("JarUtilities ZipException: (stream) " + filename));
                JarFileHandler.closeStream(jarInputStream);
                break block9;
            }
            catch (IOException iOException) {
                try {
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    JarFileHandler.closeStream(jarInputStream);
                }
            }
            JarFileHandler.closeStream(jarInputStream);
        }
        String[] names = entryNames.toArray(new String[0]);
        return names;
    }

    private static void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static String[] getEntryNames(String jarFilename, boolean excludeDirectories) {
        ArrayList<String> entryNames;
        block8: {
            ZipFile jarfile = null;
            entryNames = new ArrayList<String>();
            File f = new File(jarFilename);
            if (f.exists() && f.canRead()) {
                try {
                    jarfile = new ZipFile(f);
                    Enumeration<? extends ZipEntry> entries = jarfile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry z = entries.nextElement();
                        if (z.isDirectory() && excludeDirectories) continue;
                        entryNames.add(z.getName());
                    }
                }
                catch (ZipException zExc) {
                    LoggingService.logException((String)"oracle.eclipse.tools.webservices", (Throwable)zExc, (String)("JarUtilities ZipException: " + jarFilename + " " + zExc.getMessage()));
                    JarFileHandler.closeJarFile(jarfile);
                    break block8;
                }
                catch (IOException iOException) {
                    try {}
                    catch (Throwable throwable) {
                        JarFileHandler.closeJarFile(jarfile);
                        throw throwable;
                    }
                    JarFileHandler.closeJarFile(jarfile);
                    break block8;
                }
                JarFileHandler.closeJarFile(jarfile);
            }
        }
        return entryNames.toArray(new String[0]);
    }

    public static InputStream getInputStream(IResource jarResource, String entryName) {
        if (jarResource == null || jarResource.getType() != 1 || !jarResource.isAccessible()) {
            return null;
        }
        try {
            InputStream zipStream = ((IFile)jarResource).getContents();
            return JarFileHandler.getInputStream(jarResource.getFullPath().toString(), new ZipInputStream(zipStream), entryName);
        }
        catch (CoreException coreException) {
            IPath location = jarResource.getLocation();
            if (location != null) {
                return JarFileHandler.getInputStream(location.toString(), entryName);
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private static InputStream getInputStream(String filename, ZipInputStream zip, String entryName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream getInputStream(String jarFilename, String entryName) {
        if (jarFilename == null || jarFilename.length() < 1 || entryName == null || entryName.length() < 1) {
            return null;
        }
        String internalName = null;
        internalName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        return JarFileHandler.getCachedInputStream(jarFilename, internalName);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream getInputStream(URL url) {
        JarURLConnection jarUrlConnection;
        block25: {
            String urlString = url.toString();
            if (urlString.length() > 12 && urlString.startsWith("jar:file:") && urlString.indexOf("!/") > 9) {
                int fileIndex = urlString.indexOf("!/");
                String jarFileName = urlString.substring(9, fileIndex);
                if (fileIndex < urlString.length()) {
                    String jarPath = urlString.substring(fileIndex + 1);
                    return JarFileHandler.getInputStream(jarFileName, jarPath);
                }
            }
            InputStream input = null;
            jarUrlConnection = null;
            URLConnection openConnection = url.openConnection();
            openConnection.setDefaultUseCaches(false);
            openConnection.setUseCaches(false);
            if (openConnection instanceof JarURLConnection) {
                jarUrlConnection = (JarURLConnection)openConnection;
                JarFile jarFile = jarUrlConnection.getJarFile();
                input = jarFile.getInputStream(jarUrlConnection.getJarEntry());
            } else {
                input = openConnection.getInputStream();
            }
            if (input == null) break block25;
            InputStream inputStream = JarFileHandler.copyAndCloseStream(input);
            if (jarUrlConnection == null) return inputStream;
            try {
                jarUrlConnection.getJarFile().close();
                return inputStream;
            }
            catch (IOException iOException) {
                return inputStream;
            }
            catch (IllegalStateException illegalStateException) {}
            return inputStream;
            catch (FileNotFoundException fileNotFoundException) {
                if (jarUrlConnection == null) return null;
                try {
                    jarUrlConnection.getJarFile().close();
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
                catch (IllegalStateException illegalStateException) {}
                return null;
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webservices", (Throwable)e);
                if (jarUrlConnection == null) return null;
                {
                    catch (Throwable throwable) {
                        if (jarUrlConnection == null) throw throwable;
                        try {
                            jarUrlConnection.getJarFile().close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            throw throwable;
                        }
                        catch (IllegalStateException illegalStateException) {}
                        throw throwable;
                    }
                }
                try {
                    jarUrlConnection.getJarFile().close();
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
                catch (IllegalStateException illegalStateException) {}
                return null;
            }
        }
        if (jarUrlConnection == null) return null;
        try {
            jarUrlConnection.getJarFile().close();
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (IllegalStateException illegalStateException) {}
        return null;
    }
}

