/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;

public class FileChangeDetector {
    private Map<File, Long> previousCRCs = new HashMap<File, Long>();

    public boolean anyFileHasChanged(Collection<File> files) {
        HashMap<File, Long> newCRCs = new HashMap<File, Long>();
        boolean changeFound = false;
        for (File file : files) {
            try {
                long newCRC = FileChangeDetector.getCRC32ForFile(file).getValue();
                newCRCs.put(file, newCRC);
                Long oldCRC = this.previousCRCs.get(file);
                if (oldCRC != null && newCRC == oldCRC) continue;
                changeFound = true;
            }
            catch (IOException iOException) {
                changeFound = true;
            }
        }
        if (this.previousCRCs.size() != newCRCs.size()) {
            changeFound = true;
        }
        this.previousCRCs = newCRCs;
        return changeFound;
    }

    private static CRC32 getCRC32ForFile(File file) throws IOException {
        CRC32 existingCRC32 = new CRC32();
        try (BufferedReader in = null;){
            String s;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            while ((s = in.readLine()) != null) {
                if (s.contains(" * Date: [")) continue;
                byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
                existingCRC32.update(bytes, 0, bytes.length);
            }
        }
        return existingCRC32;
    }
}

