/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.template;

import com.bea.wlw.template.ITemplateBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateBeanAdapter;

public class WebServiceTemplateBean
extends FileTemplateBeanAdapter {
    public static final String TEMPLATE_ID = "oracle.eclipse.tools.webservices.filetemplate.newWebService";
    public static final String SEI_TEMPLATE_ID = "oracle.eclipse.tools.webservices.filetemplate.newSEIWebService";
    public static final String SEI_EXIST_TEMPLATE_ID = "oracle.eclipse.tools.webservices.filetemplate.newSEIWebServiceExist";
    public static final String CONTEXT_KEY = "webServiceBean";
    private String packageName = "";
    private String className = null;
    private String seiClassName = null;
    private boolean endpointInterface = false;
    private boolean mtom = false;
    private boolean soapMessageFormat = false;
    private PolicyRuntimeType policyType = PolicyRuntimeType.NONE;
    private Set<String> policies = Collections.emptySet();
    private List<String> methods = Collections.emptyList();
    private List<String> seiImports = Collections.emptyList();
    private Set<String> mtomPolicy = Collections.emptySet();
    private Set<String> reliabilityPolicy = Collections.emptySet();
    private Set<String> addressingPolicy = Collections.emptySet();

    public ITemplateBean getWebServiceBean() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean isEndpointInterface() {
        return this.endpointInterface;
    }

    public void setEndpointInterface(boolean endpointInterface) {
        this.endpointInterface = endpointInterface;
    }

    public PolicyRuntimeType getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(PolicyRuntimeType type) {
        this.policyType = type;
    }

    public Set<String> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Set<String> policies) {
        this.policies = policies;
    }

    public Set<String> getMtomPolicy() {
        return this.mtomPolicy;
    }

    public void setMtomPolicy(Set<String> mtomPolicy) {
        this.mtomPolicy = mtomPolicy;
    }

    public Set<String> getReliabilityPolicy() {
        return this.reliabilityPolicy;
    }

    public void setReliabilityPolicy(Set<String> reliabilityPolicy) {
        this.reliabilityPolicy = reliabilityPolicy;
    }

    public Set<String> getAddressingPolicy() {
        return this.addressingPolicy;
    }

    public void setAddressingPolicy(Set<String> addressingPolicy) {
        this.addressingPolicy = addressingPolicy;
    }

    public boolean hasPolicy() {
        return !this.getPolicyType().equals((Object)PolicyRuntimeType.NONE);
    }

    public boolean hasMultiplePolicies() {
        if (this.policies != null) {
            return this.policies.size() > 1;
        }
        return false;
    }

    public String getPolicyAnnotation() {
        StringBuilder annotation;
        block13: {
            Set<String> policies;
            block11: {
                block12: {
                    annotation = new StringBuilder();
                    policies = this.getPolicies();
                    if (policies == null) {
                        return "";
                    }
                    if (!this.hasMultiplePolicies()) break block11;
                    if (!PolicyRuntimeType.OWSM.equals((Object)this.getPolicyType())) break block12;
                    annotation.append("@SecurityPolicies({");
                    for (String policy : policies) {
                        annotation.append("@SecurityPolicy(uri = \"");
                        annotation.append(policy);
                        annotation.append("\"), ");
                    }
                    if (annotation.toString().endsWith(", ")) {
                        int len = annotation.length();
                        annotation.delete(len - 2, len);
                    }
                    annotation.append("})");
                    break block13;
                }
                if (!PolicyRuntimeType.WLS.equals((Object)this.getPolicyType())) break block13;
                annotation.append("@Policies({");
                for (String policy : policies) {
                    annotation.append("@Policy(uri = \"");
                    annotation.append(policy);
                    annotation.append("\"), ");
                }
                if (annotation.toString().endsWith(", ")) {
                    int len = annotation.length();
                    annotation.delete(len - 2, len);
                }
                annotation.append("})");
                break block13;
            }
            if (!PolicyRuntimeType.NONE.equals((Object)this.getPolicyType()) && policies.size() == 1) {
                if (PolicyRuntimeType.OWSM.equals((Object)this.getPolicyType())) {
                    policies.iterator();
                    for (String policy : policies) {
                        annotation.append("@SecurityPolicy(uri = \"");
                        annotation.append(policy);
                        annotation.append("\")");
                    }
                } else if (PolicyRuntimeType.WLS.equals((Object)this.getPolicyType())) {
                    for (String policy : policies) {
                        annotation.append("@Policy(uri = \"");
                        annotation.append(policy);
                        annotation.append("\")");
                    }
                }
            }
        }
        return annotation.toString();
    }

    public List<String> getImports() {
        ArrayList<String> implImports = new ArrayList<String>();
        if (this.hasMultiplePolicies()) {
            if (PolicyRuntimeType.OWSM.equals((Object)this.getPolicyType())) {
                implImports.add("weblogic.wsee.jws.jaxws.owsm.SecurityPolicies");
                implImports.add("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy");
            } else if (PolicyRuntimeType.WLS.equals((Object)this.getPolicyType())) {
                implImports.add("weblogic.jws.Policies");
                implImports.add("weblogic.jws.Policy");
            }
        } else if (!PolicyRuntimeType.NONE.equals((Object)this.getPolicyType()) && this.policies.size() == 1) {
            if (PolicyRuntimeType.OWSM.equals((Object)this.getPolicyType())) {
                implImports.add("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy");
            } else if (PolicyRuntimeType.WLS.equals((Object)this.getPolicyType())) {
                implImports.add("weblogic.jws.Policy");
            }
        }
        if (this.isMtom()) {
            implImports.add("javax.xml.ws.soap.MTOM");
        }
        Collections.sort(implImports);
        return implImports;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public List<String> getSeiImports() {
        return this.seiImports;
    }

    public void setSeiImports(List<String> seiImports) {
        this.seiImports = seiImports;
    }

    public String getSeiClassName() {
        return this.seiClassName;
    }

    public void setSeiClassName(String seiClassName) {
        this.seiClassName = seiClassName;
    }

    public boolean isMtom() {
        return this.mtom;
    }

    public void setMtom(boolean mtom) {
        this.mtom = mtom;
    }

    public void setSoapMessageFormat(boolean soapMessageFormat) {
        this.soapMessageFormat = soapMessageFormat;
    }

    public boolean isSoapMessageFormat() {
        return this.soapMessageFormat;
    }

    public static enum PolicyRuntimeType {
        OWSM("OWSM"),
        WLS("WEBLOGIC"),
        NONE("NONE");

        private final String name;

        private PolicyRuntimeType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

